<?php
include('header.php');
include('functions.php');
?>

<?php if (!empty($_SESSION['success_message'])): ?>
    <!-- Inline Alert -->
    <div class="alert alert-success text-center flash-message" id="flash-success">
        <?php 
            echo $_SESSION['success_message']; 
            unset($_SESSION['success_message']); 
        ?>
    </div>
<?php endif; ?>

<?php if (!empty($_SESSION['error_message'])): ?>
    <!-- Inline Alert -->
    <div class="alert alert-danger text-center flash-message" id="flash-error">
        <?php 
            echo $_SESSION['error_message']; 
            unset($_SESSION['error_message']); 
        ?>
    </div>
<?php endif; ?>


<style>
.flash-message {
    transition: opacity 1s ease-out;
}
.flash-message.fade-out {
    opacity: 0;
}
</style>

<h1>User List</h1>
<hr>

<div class="row">
    <div class="col-xs-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h4>Users</h4>
            </div>
            <div class="panel-body form-group form-group-sm">
                <?php getUsers(); ?>
            </div>
        </div>
    </div>
</div>

<div id="delete_user" class="modal fade">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
        <h4 class="modal-title">Delete User</h4>
      </div>
      <div class="modal-body">
        <p>Are you sure you want to delete this user?</p>
      </div>
      <div class="modal-footer">
        <form method="post" action="user-delete.php" id="deleteForm">
          <input type="hidden" name="id" id="deleteUserId">
          <button type="submit" class="btn btn-danger">Delete</button>
          <button type="button" data-dismiss="modal" class="btn btn-default">Cancel</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
// fade inline messages
setTimeout(function() {
    let success = document.getElementById("flash-success");
    let error = document.getElementById("flash-error");

    if (success) {
        success.classList.add("fade-out");
        setTimeout(() => success.style.display = "none", 1000);
    }
    if (error) {
        error.classList.add("fade-out");
        setTimeout(() => error.style.display = "none", 1000);
    }
}, 3000);

// pass user id to hidden input in modal
document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll(".delete-user").forEach(function(button) {
        button.addEventListener("click", function() {
            let userId = this.getAttribute("data-user-id");
            document.getElementById("deleteUserId").value = userId;
        });
    });
});
</script>

<?php include('footer.php'); ?>
