<?php
// ✅ Start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/includes/config.php';

// ✅ Connect DB
$mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);
if ($mysqli->connect_error) {
    die("Database Connection Failed: " . $mysqli->connect_error);
}

// ✅ Get ID
$getID = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// ✅ Handle Update BEFORE any HTML
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'update_user') {
    $id       = (int)$_POST['id'];
    $name     = $mysqli->real_escape_string($_POST['name']);
    $username = $mysqli->real_escape_string($_POST['username']);
    $email    = $mysqli->real_escape_string($_POST['email']);
    $phone    = $mysqli->real_escape_string($_POST['phone']);

    if (!empty($_POST['password'])) {
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $query = "UPDATE users 
                  SET name='$name', username='$username', email='$email', phone='$phone', password='$password'
                  WHERE id='$id'";
    } else {
        $query = "UPDATE users 
                  SET name='$name', username='$username', email='$email', phone='$phone'
                  WHERE id='$id'";
    }

    if ($mysqli->query($query)) {
        $_SESSION['success_message'] = "✅ User updated successfully!";
        $mysqli->close();
        header("Location: user-list.php"); // ✅ Safe redirect (no output before)
        exit;
    } else {
        $error_message = "❌ Error updating user: " . $mysqli->error;
    }
}

// ✅ Fetch user details
$query = "SELECT * FROM users WHERE id = '$getID' LIMIT 1";
$result = $mysqli->query($query);

if ($result && $result->num_rows > 0) {
    $row      = $result->fetch_assoc();
    $name     = $row['name'];
    $username = $row['username'];
    $email    = $row['email'];
    $phone    = $row['phone'];
} else {
    die("User not found!");
}

$mysqli->close();

// ✅ Include header AFTER logic
include('header.php');
?>

<h1>Edit User</h1>
<hr>

<?php if (!empty($error_message)): ?>
    <div class="alert alert-danger text-center"><?php echo $error_message; ?></div>
<?php endif; ?>

<div class="row">
    <div class="col-xs-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h4>Editing User (<?php echo $getID; ?>)</h4>
            </div>
            <div class="panel-body form-group form-group-sm">
                <form method="post" action="">
                    <input type="hidden" name="action" value="update_user">
                    <input type="hidden" name="id" value="<?php echo $getID; ?>">

                    <div class="row">
                        <div class="col-xs-4">
                            <input type="text" class="form-control margin-bottom required" name="name" value="<?php echo htmlspecialchars($name); ?>" required>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" class="form-control margin-bottom required" name="username" value="<?php echo htmlspecialchars($username); ?>" required>
                        </div>
                        <div class="col-xs-4">
                            <input type="email" class="form-control margin-bottom required" name="email" value="<?php echo htmlspecialchars($email); ?>" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xs-4">
                            <input type="text" class="form-control" name="phone" value="<?php echo htmlspecialchars($phone); ?>">
                        </div>
                        <div class="col-xs-4">
                            <input type="password" class="form-control" name="password" placeholder="Enter new password (leave blank to keep current)">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xs-12 margin-top btn-group">
                            <button type="submit" class="btn btn-success float-right">Update User</button>
                            <a href="user-list.php" class="btn btn-default">Cancel</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    setTimeout(function() {
        let flash = document.getElementById("flash-message");
        if (flash) {
            flash.style.transition = "opacity 0.5s ease";
            flash.style.opacity = "0";
            setTimeout(() => flash.remove(), 500);
        }
    }, 3000); // 3 seconds
</script>

<?php include('footer.php'); ?>
