<?php


require_once __DIR__ . '/includes/config.php';

// ✅ Connect to DB
$mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);
if ($mysqli->connect_error) {
    die("Database connection failed: " . $mysqli->connect_error);
}

// ✅ Handle form submission BEFORE any HTML
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_user') {
    $name     = mysqli_real_escape_string($mysqli, $_POST['name']);
    $username = mysqli_real_escape_string($mysqli, $_POST['username']);
    $email    = mysqli_real_escape_string($mysqli, $_POST['email']);
    $phone    = mysqli_real_escape_string($mysqli, $_POST['phone']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    $query = "INSERT INTO users (name, username, email, phone, password) 
              VALUES ('$name', '$username', '$email', '$phone', '$password')";

    if ($mysqli->query($query)) {
        $_SESSION['success_message'] = "✅ User added successfully!";
        header("Location: user-list.php");
        exit;
    } else {
        $error_message = "❌ Error: " . $mysqli->error;
    }
}

// ✅ Now include header (after logic is done)
include('header.php');
?>

<h1>Add User</h1>
<hr>

<!-- ❌ Show error messages here -->
<?php if (!empty($error_message)): ?>
    <div class="alert alert-danger text-center">
        <?php echo $error_message; ?>
    </div>
<?php endif; ?>

<div class="row">
    <div class="col-xs-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h4>User Information</h4>
            </div>
            <div class="panel-body form-group form-group-sm">
                <!-- ✅ Post back to same page -->
                <form method="post" action="">
                    <input type="hidden" name="action" value="add_user">

                    <div class="row">
                        <div class="col-xs-4">
                            <input type="text" class="form-control margin-bottom required" name="name" placeholder="Name" required>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" class="form-control margin-bottom required" name="username" placeholder="Enter username" required>
                        </div>
                        <div class="col-xs-4">
                            <input type="email" class="form-control margin-bottom required" name="email" placeholder="Enter user's email address" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xs-4">
                            <input type="text" class="form-control" name="phone" placeholder="Enter user's phone number">
                        </div>
                        <div class="col-xs-4">
                            <input type="password" class="form-control required" name="password" placeholder="Enter user's password" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xs-12 margin-top btn-group">
                            <button type="submit" class="btn btn-success float-right">Add user</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('footer.php'); ?>
