<?php
include_once("includes/config.php");

if (isset($_GET['id'])) {
    $invoiceId = intval($_GET['id']);

    // connect DB
    $mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);

    if ($mysqli->connect_error) {
        die('Error : ('.$mysqli->connect_errno .') '. $mysqli->connect_error);
    }

    // get invoice + customer email
    $query = "SELECT i.invoice, c.name, c.email 
              FROM invoices i
              JOIN customers c ON c.invoice = i.invoice
              WHERE i.invoice = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param("i", $invoiceId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        $to = $row['email'];
        $subject = "Invoice #".$row['invoice'];
        $message = "Dear ".$row['name'].",\n\nPlease find attached your invoice.";
        $headers = "From: no-reply@yourdomain.com";

        // try attaching PDF (basic way)
        $pdfFile = "invoices/".$row['invoice'].".pdf";

        if (file_exists($pdfFile)) {
            // For proper attachment, use PHPMailer
            // Here just send a link
            $message .= "\n\nDownload your invoice: http://localhost/Invoice-System-In-PHP-main/".$pdfFile;
        }

        if (mail($to, $subject, $message, $headers)) {
            echo "<script>alert('Invoice sent to ".$to."'); window.location='invoice-list.php';</script>";
        } else {
            echo "<script>alert('Error sending email'); window.location='invoice-list.php';</script>";
        }
    } else {
        echo "<script>alert('Invoice not found'); window.location='invoice-list.php';</script>";
    }

    $stmt->close();
    $mysqli->close();
} else {
    header("Location: invoice-list.php");
    exit();
}
?>
