<?php

header('Content-Type: application/json'); // Always return JSON
include_once('includes/config.php');

// Show PHP errors during debugging (disable in production)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Connect to database
$mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);
if ($mysqli->connect_error) {
    echo json_encode([
        "status" => "error",
        "message" => "DB Connection failed: " . $mysqli->connect_error
    ]);
    exit;
}

// Get action
$action = $_POST['action'] ?? "";

// -----------------------------
// Create Invoice
// -----------------------------
if ($action === 'create_invoice') {
    $invoice_id     = $_POST['invoice_id'] ?? null;
    $customer_id    = $_POST['customer_id'] ?? null;
    $invoice_date   = $_POST['invoice_date'] ?? null;
    $due_date       = $_POST['invoice_due_date'] ?? null;
    $subtotal       = $_POST['subtotal'] ?? 0;
    $discount       = $_POST['discount'] ?? 0;
    $vat            = $_POST['vat'] ?? 0;
    $total          = $_POST['total'] ?? 0;
    $notes          = $_POST['notes'] ?? '';
    $invoice_type   = $_POST['invoice_type'] ?? 'standard';
    $status         = $_POST['status'] ?? 'open';

    $stmt = $mysqli->prepare("INSERT INTO invoices 
        (invoice, customer_id, invoice_date, invoice_due_date, subtotal, discount, vat, total, notes, invoice_type, status)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param(
        "iissdddddss",
        $invoice_id, $customer_id, $invoice_date, $due_date, 
        $subtotal, $discount, $vat, $total, $notes, $invoice_type, $status
    );

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Invoice created successfully",
            "invoice_id" => $mysqli->insert_id
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Failed to create invoice: " . $stmt->error
        ]);
    }
    $stmt->close();
    exit;
}

// -----------------------------
// Delete Invoice
// -----------------------------
if ($action === 'delete_invoice') {
    $invoiceId = $_POST['id'] ?? '';

    if (empty($invoiceId)) {
        echo json_encode([
            "status" => "error",
            "message" => "Missing invoice ID"
        ]);
        exit;
    }

    $stmt = $mysqli->prepare("DELETE FROM invoices WHERE invoice = ?");
    $stmt->bind_param("i", $invoiceId);

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Invoice deleted successfully"
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Failed to delete invoice: " . $stmt->error
        ]);
    }
    $stmt->close();
    exit;
}

// -----------------------------
// Email Invoice
// -----------------------------
if ($action === 'email_invoice') {
    $fileId  = $_POST['id'] ?? '';
    $emailId = $_POST['email'] ?? '';

    if (empty($fileId) || empty($emailId)) {
        echo json_encode([
            "status" => "error",
            "message" => "Missing invoice ID or email"
        ]);
        exit;
    }

    // Example: Replace with PHPMailer or real email logic
    $sent = true; // simulate success

    if ($sent) {
        echo json_encode([
            "status" => "success",
            "message" => "Invoice #$fileId emailed to $emailId"
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Failed to send invoice"
        ]);
    }
    exit;
}

// -----------------------------
// Default Fallback
// -----------------------------
echo json_encode([
    "status" => "error",
    "message" => "Invalid action requested"
]);
exit;
