<?php
// Start session at the VERY TOP
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Include database configuration
include('includes/config.php');

// Check if ID parameter exists and is valid
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    $_SESSION['error'] = "Invalid product ID.";
    header('Location: product-list.php');
    exit();
}

$product_id = intval($_GET['id']);

// Connect to database
$mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);
if ($mysqli->connect_error) {
    $_SESSION['error'] = 'Database Connection Error: ' . $mysqli->connect_error;
    header('Location: product-list.php');
    exit();
}

// First, check if the product exists and get its name for the message
$check_stmt = $mysqli->prepare("SELECT product_name FROM products WHERE product_id = ?");
$check_stmt->bind_param("i", $product_id);
$check_stmt->execute();
$check_result = $check_stmt->get_result();

if ($check_result->num_rows === 0) {
    $_SESSION['error'] = "Product not found.";
    $check_stmt->close();
    $mysqli->close();
    header('Location: product-list.php');
    exit();
}

$product = $check_result->fetch_assoc();
$product_name = $product['product_name'];
$check_stmt->close();

// Delete the product
$delete_stmt = $mysqli->prepare("DELETE FROM products WHERE product_id = ?");
$delete_stmt->bind_param("i", $product_id);

if ($delete_stmt->execute()) {
    $_SESSION['success'] = "Product '" . htmlspecialchars($product_name) . "' deleted successfully!";
} else {
    $_SESSION['error'] = "Error deleting product: " . $delete_stmt->error;
}

$delete_stmt->close();
$mysqli->close();

// Redirect back to product list page
header('Location: product-list.php');
exit();
?>