<?php
include('header.php');

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!defined('CURRENCY')) {
    define('CURRENCY', '$');
}

// Process form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if it's a regular form submission or AJAX
    $is_ajax = !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
    
    $name  = trim($_POST['product_name'] ?? '');
    $desc  = trim($_POST['product_desc'] ?? '');
    $price = trim($_POST['product_price'] ?? '');
    $action = $_POST['action'] ?? '';

    // Validate action
    if ($action !== 'add_product') {
        if ($is_ajax) {
            echo json_encode(['error' => 'Invalid action requested']);
            exit();
        } else {
            $_SESSION['error'] = 'Invalid action requested';
            header('Location: product-add.php');
            exit();
        }
    }

    // Validate required fields
    if (empty($name) || empty($desc) || empty($price)) {
        $error_msg = 'Please fill all required fields.';
        if ($is_ajax) {
            echo json_encode(['error' => $error_msg]);
            exit();
        } else {
            $_SESSION['error'] = $error_msg;
            header('Location: product-add.php');
            exit();
        }
    }

    // Validate price is numeric
    if (!is_numeric($price) || $price < 0) {
        $error_msg = 'Please enter a valid price.';
        if ($is_ajax) {
            echo json_encode(['error' => $error_msg]);
            exit();
        } else {
            $_SESSION['error'] = $error_msg;
            header('Location: product-add.php');
            exit();
        }
    }

    // Database operation
    $mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);
    if ($mysqli->connect_error) {
        $error_msg = 'Database Connection Error: ' . $mysqli->connect_error;
        if ($is_ajax) {
            echo json_encode(['error' => $error_msg]);
            exit();
        } else {
            $_SESSION['error'] = $error_msg;
            header('Location: product-add.php');
            exit();
        }
    }

    $stmt = $mysqli->prepare("INSERT INTO products (product_name, product_desc, product_price) VALUES (?, ?, ?)");
    $stmt->bind_param("ssd", $name, $desc, $price);

    if ($stmt->execute()) {
        $success_msg = 'Product added successfully!';
        if ($is_ajax) {
            echo json_encode(['success' => $success_msg]);
            exit();
       
        }
    } else {
        $error_msg = 'Database error: ' . $stmt->error;
        if ($is_ajax) {
            echo json_encode(['error' => $error_msg]);
            exit();
        } else {
            $_SESSION['error'] = $error_msg;
            header('Location: product-add.php');
            exit();
        }
    }

    $stmt->close();
    $mysqli->close();
}

// Display messages from session
if (isset($_SESSION['error'])) {
    echo "<div class='alert alert-danger'>
            <a href='#' class='close' data-dismiss='alert'>&times;</a>
            " . htmlspecialchars($_SESSION['error']) . "
          </div>";
    unset($_SESSION['error']);
}

if (isset($_SESSION['success'])) {
    echo "<div class='alert alert-success'>
            <a href='#' class='close' data-dismiss='alert'>&times;</a>
            " . htmlspecialchars($_SESSION['success']) . "
          </div>";
    unset($_SESSION['success']);
}
?>

<h2>Add Product</h2>
<hr>
                        
<div class="row">
    <div class="col-xs-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h4>Product Information</h4>
            </div>
            <div class="panel-body form-group form-group-sm">
                <form method="post" id="add_product" action="product-add.php">
                    <input type="hidden" name="action" value="add_product">

                    <div class="row">
                        <div class="col-xs-4">
                            <input type="text" class="form-control required" name="product_name" placeholder="Enter Product Name" required>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" class="form-control required" name="product_desc" placeholder="Enter Product Description" required>
                        </div>
                        <div class="col-xs-4">
                            <div class="input-group">
                                <span class="input-group-addon"><?php echo CURRENCY ?></span>
                                <input type="number" name="product_price" class="form-control required" placeholder="0.00" step="0.01" min="0" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 margin-top btn-group">
                            <button type="submit" class="btn btn-success float-right">Add Product</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('footer.php'); ?>