<?php
require_once 'includes/config.php'; // make sure this defines DATABASE_HOST, etc.

if (isset($_GET['delete'])) {
    $invoice_number = $_GET['delete'];

    // Connect to the database
    $mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);

    if ($mysqli->connect_error) {
        die('Connection Error: (' . $mysqli->connect_errno . ') ' . $mysqli->connect_error);
    }

    // Use prepared statement for safety
    $stmt = $mysqli->prepare("DELETE FROM invoices WHERE invoice_number = ?");
    $stmt->bind_param("s", $invoice_number);

    if ($stmt->execute()) {
        // ✅ Successfully deleted
        echo "<script>alert('Invoice deleted successfully'); window.location='invoice-list.php';</script>";
    } else {
        // ❌ Error while deleting
        echo "<script>alert('Failed to delete invoice'); window.location='invoice-list.php';</script>";
    }

    $stmt->close();
    $mysqli->close();
} else {
    // No delete parameter
    header("Location: invoices.php");
    exit();
}
?>
