<?php
include('header-login.php');
include('functions.php');

if (!empty($_SESSION['login_error'])): ?>
    <div class="alert alert-danger text-center">
        <?php 
            echo $_SESSION['login_error']; 
            unset($_SESSION['login_error']);
        ?>
    </div>
<?php endif;
?>

<style>
    html, body {
        height: 100%;
        margin: 0;
        padding: 0;
        font-family: "Segoe UI", Arial, sans-serif;
        background: linear-gradient(135deg, #4B0082, #7B1FA2);
    }

    /* ✅ Use Flexbox to perfectly center */
    .login-page {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
    }

    .login-card {
        background: #fff;
        border-radius: 16px;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
        width: 360px;
        padding: 40px 30px;
        text-align: center;
        animation: fadeIn 0.8s ease-in-out;
    }

    .login-card img {
        width: 90px;
        height: 90px;
        border-radius: 50%;
        object-fit: cover;
        margin-bottom: 10px;
        border: 3px solid #6A1B9A;
    }

    .login-card h2 {
        color: #4B0082;
        margin-bottom: 25px;
        font-weight: 600;
    }

    .form-control {
        border-radius: 25px;
        padding: 10px 18px;
        margin-bottom: 15px;
    }

    .btn-login {
        background-color: #4B0082;
        border: none;
        border-radius: 25px;
        color: white;
        padding: 10px;
        font-weight: 500;
        width: 100%;
        transition: 0.3s;
    }

    .btn-login:hover {
        background-color: #6A1B9A;
        transform: translateY(-2px);
    }

    .checkbox {
        text-align: left;
        color: #555;
        margin-bottom: 15px;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    @media (max-width: 480px) {
        .login-card {
            width: 90%;
            padding: 30px 20px;
        }
    }
</style>

<div class="login-page">
    <div class="login-card">
        <img src="images/logo.png" alt="Yakutech Logo">
        <h2>Yakutech Login</h2>

        <form method="post" id="login_form" action="login.php">
            <input type="hidden" name="action" value="login">

            <div class="form-group">
                <input class="form-control" name="username" id="username" type="text" placeholder="Enter Username" required>
            </div>

            <div class="form-group">
                <input class="form-control" name="password" type="password" placeholder="Enter Password" required>
            </div>

            <div class="checkbox">
                <label><input name="remember" type="checkbox" value="1"> Remember Me</label>
            </div>

            <button type="submit" class="btn-login">Login</button>
        </form>
    </div>
</div>

<?php include('footer.php'); ?>
