<?php

include_once("includes/config.php");

// ================================
// get invoice list
// ================================
// ================================
// get invoice list
// ================================
if (!function_exists('getInvoices')) {
    function getInvoices() {
        $mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);

        if ($mysqli->connect_error) {
            die('Error : (' . $mysqli->connect_errno . ') ' . $mysqli->connect_error);
        }

        // ✅ Fetch invoices only
        $query = "SELECT invoice_number, invoice_date, customer_pin, customer_name, invoice_status 
                  FROM invoices 
                  ORDER BY invoice_number";

        $results = $mysqli->query($query);

        if ($results && $results->num_rows > 0) {
            echo '<table class="table table-striped table-hover table-bordered" id="data-table" cellspacing="0">
                    <thead>
                      <tr>
                        <th>Invoice Number</th>
                        <th>Invoice Date</th>
                        <th>Customer PIN</th>
                        <th>Customer Name</th>
                        <th>Status</th>
                        <th>Actions</th>
                      </tr>
                    </thead>
                    <tbody>';

            while ($row = $results->fetch_assoc()) {
                $invoice_number = htmlspecialchars($row['invoice_number']);
                $invoice_date = htmlspecialchars($row['invoice_date']);
                $customer_pin = htmlspecialchars($row['customer_pin']);
                $customer_name = htmlspecialchars($row['customer_name']);
                $invoice_status = htmlspecialchars($row['invoice_status']);

                echo '<tr>
                        <td>' . $invoice_number . '</td>
                        <td>' . $invoice_date . '</td>
                        <td>' . $customer_pin . '</td>
                        <td>' . $customer_name . '</td>
                        <td>' . $invoice_status . '</td>
                        <td>';

                // 📝 Edit button
                echo '<a href="invoice-edit.php?id=' . urlencode($invoice_number) . '" class="btn btn-primary btn-xs">
                        <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                      </a> ';

                // 🖨️ Print button
                echo '<a href="print_invoice.php?id=' . urlencode($invoice_number) . '" 
                        class="btn btn-info btn-xs" target="_blank" title="Print Invoice">
                        <span class="glyphicon glyphicon-print" aria-hidden="true"></span>
                      </a> ';

                // ❌ Delete button
                echo '<a href="invoices_delete.php?delete=' . urlencode($invoice_number) . '" 
                        onclick="return confirm(\'Are you sure you want to delete this invoice?\')" 
                        class="btn btn-danger btn-xs" title="Delete Invoice">
                        <span class="glyphicon glyphicon-trash" aria-hidden="true"></span>
                      </a> ';

                // 📧 Send via Gmail button (PHPMailer)
               echo '<a href="debug_email_step_by_step.php?invoice_number=' . urlencode($invoice_number) . '" 
        class="btn btn-success btn-xs"
        title="Send Invoice via Gmail"
        onclick="return confirm(\'Send this invoice to ' . htmlspecialchars($customer_name) . '?\');">
        <span class="glyphicon glyphicon-envelope"></span> Send
      </a>';

                echo '</td></tr>';
            }

            echo '</tbody></table>';
        } else {
            echo "<p>There are no invoices to display.</p>";
        }

        if ($results) {
            $results->free();
        }
        $mysqli->close();
    }
}


// ================================
// get initial invoice number

// ================================
// get initial invoice number
// ================================
if (!function_exists('getInvoiceId')) {
    function getInvoiceId() {
        $mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);

        if ($mysqli->connect_error) {
            die('Error : (' . $mysqli->connect_errno . ') ' . $mysqli->connect_error);
        }

        $query = "SELECT invoice FROM invoices ORDER BY invoice DESC LIMIT 1";
        if ($result = $mysqli->query($query)) {
            $row_cnt = $result->num_rows;
            $row = mysqli_fetch_assoc($result);

            if ($row_cnt == 0) {
                echo INVOICE_INITIAL_VALUE;
            } else {
                echo $row['invoice'] + 1;
            }

            $result->free();
            $mysqli->close();
        }
    }
}

// ================================
// populate product dropdown
// ================================

// ================================
// get products list
// ================================
if (!function_exists('getProducts')) {
    function getProducts() {
        $mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);

        if ($mysqli->connect_error) {
            die('Error : (' . $mysqli->connect_errno . ') ' . $mysqli->connect_error);
        }

        $query = "SELECT * FROM products ORDER BY product_name ASC";
        $results = $mysqli->query($query);

        if ($results) {
            echo '<table class="table table-striped table-hover table-bordered" id="data-table">
                    <thead>
                      <tr>
                        <th>Product</th>
                        <th>Description</th>
                        <th>Price</th>
                        <th>Action</th>
                      </tr>
                    </thead>
                    <tbody>';

            while ($row = $results->fetch_assoc()) {
                echo '<tr>
                        <td>' . $row["product_name"] . '</td>
                        <td>' . $row["product_desc"] . '</td>
                        <td>$' . $row["product_price"] . '</td>
                        <td>
                          <a href="product-edit.php?id=' . $row["product_id"] . '" class="btn btn-primary btn-xs">
                            <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                          </a> 
                          <a href="product-delete.php?id=' . $row["product_id"] . '" 
                             onclick="return confirm(\'Are you sure you want to delete this product?\')" 
                             class="btn btn-danger btn-xs">
                            <span class="glyphicon glyphicon-trash" aria-hidden="true"></span>
                          </a>
                        </td>
                      </tr>';
            }

            echo '</tbody></table>';
        } else {
            echo "<p>There are no products to display.</p>";
        }

        $results->free();
        $mysqli->close();
    }
}

// <?php
function getUsers() {
    require __DIR__ . '/includes/config.php';
    $mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);

    if ($mysqli->connect_error) {
        die("DB Connection failed: " . $mysqli->connect_error);
    }

    $query = "SELECT id, name, username, email, phone FROM users ORDER BY id DESC";
    $result = $mysqli->query($query);

    if ($result && $result->num_rows > 0) {
        echo '<table class="table table-bordered table-striped">';
        echo '<thead>';
        echo '<tr>';
        echo '<th>ID</th>';
        echo '<th>Name</th>';
        echo '<th>Username</th>';
        echo '<th>Email</th>';
        echo '<th>Phone</th>';
        echo '<th>Actions</th>';
        echo '</tr>';
        echo '</thead>';
        echo '<tbody>';

        while ($row = $result->fetch_assoc()) {
            echo '<tr>';
            echo '<td>' . htmlspecialchars($row['id']) . '</td>';
            echo '<td>' . htmlspecialchars($row['name']) . '</td>';
            echo '<td>' . htmlspecialchars($row['username']) . '</td>';
            echo '<td>' . htmlspecialchars($row['email']) . '</td>';
            echo '<td>' . htmlspecialchars($row['phone']) . '</td>';
            echo '<td>
                    <a href="user-edit.php?id=' . $row['id'] . '" class="btn btn-primary btn-xs">
                        <span class="glyphicon glyphicon-pencil"></span> Edit
                    </a>
                    <a href="#" 
                       data-user-id="' . $row['id'] . '" 
                       class="btn btn-danger btn-xs delete-user" 
                       data-toggle="modal" 
                       data-target="#delete_user">
                        <span class="glyphicon glyphicon-trash"></span> Delete
                    </a>
                  </td>';
            echo '</tr>';
        }

        echo '</tbody>';
        echo '</table>';
    } else {
        echo '<div class="alert alert-info text-center">No users found.</div>';
    }

    $mysqli->close();
}


?>