<?php
include_once("includes/config.php");

// Check if delete parameter is set
if (isset($_GET['delete']) && !empty($_GET['delete'])) {
    $customer_id = intval($_GET['delete']);
    
    // Create database connection
    $mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);
    
    if ($mysqli->connect_error) {
        die('Error : (' . $mysqli->connect_errno . ') ' . $mysqli->connect_error);
    }
    
    // Prepare and execute delete statement
    $stmt = $mysqli->prepare("DELETE FROM customers WHERE id = ?");
    $stmt->bind_param("i", $customer_id);
    
    if ($stmt->execute()) {
        // Success - redirect back to customers page
        header("Location: customer-list.php?message=Customer+deleted+successfully");
        exit();
    } else {
        // Error
        header("Location: customer-list.php?error=Error+deleting+customer");
        exit();
    }
    
    $stmt->close();
    $mysqli->close();
} else {
    // No ID provided
    header("Location: customers.php?error=No+customer+ID+provided");
    exit();
}
?>