<?php
// send_invoice_complete.php
session_start();

// Clear ALL output buffers completely
while (ob_get_level() > 0) {
    ob_end_clean();
}

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Import statements
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Dompdf\Dompdf;

// Require files
require __DIR__ . '/PHPMailer/src/Exception.php';
require __DIR__ . '/PHPMailer/src/PHPMailer.php';
require __DIR__ . '/PHPMailer/src/SMTP.php';
include __DIR__ . '/includes/config.php';
require __DIR__ . '/dompdf/autoload.inc.php';

$invoice_number = $_GET['invoice_number'] ?? '';

try {
    if (empty($invoice_number)) {
        throw new Exception("No invoice number provided");
    }

    // 1. Get invoice data using your exact table structure
    if (!$mysqli) {
        throw new Exception("Database connection failed");
    }

    // Get the invoice with all fields
    $stmt = $mysqli->prepare("SELECT * FROM invoices WHERE invoice_number = ?");
    $stmt->bind_param("s", $invoice_number);
    $stmt->execute();
    $result = $stmt->get_result();
    $invoice = $result->fetch_assoc();

    if (!$invoice) {
        throw new Exception("Invoice not found: $invoice_number");
    }

    // Check if customer email is provided
    if (empty($invoice['customer_email'])) {
        throw new Exception("Customer email is empty for invoice {$invoice_number}. Please add an email address to send the invoice.");
    }

    // Get invoice items
    $invoice_items = [];
    $items_stmt = $mysqli->prepare("SELECT * FROM invoice_items WHERE invoice_id = ?");
    $items_stmt->bind_param("i", $invoice['id']);
    $items_stmt->execute();
    $items_result = $items_stmt->get_result();
    while ($item = $items_result->fetch_assoc()) {
        $invoice_items[] = $item;
    }

    // 2. Generate PDF with professional design
    $pdfDir = __DIR__ . "/invoices/";
    if (!file_exists($pdfDir)) mkdir($pdfDir, 0777, true);
    $pdfPath = $pdfDir . $invoice_number . ".pdf";

    // Check if logo exists - try multiple possible locations
    $logoPaths = [
        __DIR__ . '/images/yakutech-logo.png',
        __DIR__ . '/images/logo.png',
        __DIR__ . '/assets/images/yakutech-logo.png',
        __DIR__ . '/assets/images/logo.png',
        __DIR__ . '/yakutech-logo.png',
        __DIR__ . '/logo.png'
    ];
    
    $logoPath = null;
    $logoBase64 = null;
    
    foreach ($logoPaths as $path) {
        if (file_exists($path)) {
            $logoPath = $path;
            $logoBase64 = base64_encode(file_get_contents($path));
            break;
        }
    }
    
    $logoExists = ($logoPath !== null);

    // Generate HTML for PDF
    ob_start();
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <title>Invoice <?php echo $invoice_number; ?> - Yakutech Solutions Limited</title>
        <style>
            @page { margin: 50px 40px; }
            body { 
                font-family: 'Helvetica', 'Arial', sans-serif; 
                margin: 0; 
                padding: 0;
                color: #333;
                line-height: 1.4;
                font-size: 12px;
            }
            .header { 
                display: flex;
                justify-content: space-between;
                align-items: flex-start;
                margin-bottom: 30px;
                padding-bottom: 20px;
                border-bottom: 3px solid #2c5aa0;
            }
            .logo-section {
                flex: 1;
            }
            .logo-placeholder {
                width: 180px;
                height: 70px;
                background: linear-gradient(135deg, #2c5aa0, #1e3a6b);
                color: white;
                display: flex;
                align-items: center;
                justify-content: center;
                font-weight: bold;
                font-size: 16px;
                border-radius: 8px;
                text-align: center;
                padding: 10px;
            }
            .logo-image {
                height: 70px;
                max-width: 180px;
                object-fit: contain;
            }
            .invoice-info-section {
                flex: 1;
                text-align: right;
            }
            .company-name { 
                font-size: 22px; 
                font-weight: bold; 
                color: #2c5aa0; 
                margin-bottom: 5px;
            }
            .invoice-title { 
                font-size: 24px; 
                font-weight: bold; 
                color: #d35400; 
                margin: 10px 0;
                text-transform: uppercase;
                letter-spacing: 1px;
            }
            .invoice-meta {
                background: #f8f9fa;
                padding: 15px;
                border-radius: 8px;
                margin: 15px 0;
            }
            .meta-grid {
                display: grid;
                grid-template-columns: 1fr 1fr;
                gap: 10px;
            }
            .meta-item {
                margin-bottom: 8px;
            }
            .meta-label {
                font-weight: bold;
                color: #2c5aa0;
            }
            .details-container { 
                display: grid;
                grid-template-columns: 1fr 1fr;
                gap: 30px;
                margin: 25px 0;
            }
            .section-card {
                background: #f8f9fa;
                padding: 20px;
                border-radius: 8px;
                border-left: 4px solid #2c5aa0;
            }
            .section-title { 
                font-weight: bold; 
                margin-bottom: 15px; 
                color: #2c5aa0;
                font-size: 14px;
                text-transform: uppercase;
                letter-spacing: 0.5px;
            }
            .table-container {
                margin: 25px 0;
                overflow: visible;
            }
            .table { 
                width: 100%; 
                border-collapse: collapse;
                border-spacing: 0;
                margin: 0;
            }
            .table thead {
                display: table-header-group;
            }
            .table th { 
                background: #2c5aa0 !important; 
                color: white !important;
                border: 1px solid #1e3a6b !important; 
                padding: 12px 10px !important; 
                text-align: left; 
                font-weight: bold;
                font-size: 11px;
                text-transform: uppercase;
                letter-spacing: 0.5px;
            }
            .table td { 
                border: 1px solid #dee2e6; 
                padding: 12px 10px; 
                font-size: 11px;
                background: white;
            }
            .table tr:nth-child(even) td {
                background-color: #f8f9fa;
            }
            .total-row { 
                font-weight: bold; 
                background-color: #e9ecef !important;
                font-size: 12px;
            }
            .text-right { text-align: right; }
            .text-center { text-align: center; }
            .footer { 
                margin-top: 40px; 
                padding-top: 20px; 
                border-top: 2px solid #2c5aa0; 
                text-align: center; 
                color: #666; 
                font-size: 11px;
            }
            .amount-summary { 
                background: linear-gradient(135deg, #f8f9fa, #e9ecef);
                padding: 20px;
                border-radius: 8px;
                margin: 25px 0;
                border: 1px solid #dee2e6;
            }
            .summary-table {
                width: 300px;
                margin-left: auto;
                border-collapse: collapse;
            }
            .summary-table td {
                padding: 8px 5px;
                border-bottom: 1px solid #dee2e6;
            }
            .total-amount {
                font-size: 16px;
                color: #d35400;
                font-weight: bold;
            }
            .notes-section {
                background: #fff3cd;
                padding: 15px;
                border-radius: 6px;
                border-left: 4px solid #ffc107;
                margin: 20px 0;
                font-size: 11px;
            }
            .watermark {
                position: fixed;
                bottom: 50%;
                right: 50%;
                transform: translate(50%, 50%) rotate(-45deg);
                opacity: 0.03;
                font-size: 80px;
                font-weight: bold;
                color: #2c5aa0;
                pointer-events: none;
                z-index: -1;
            }
            /* Ensure table headers print correctly */
            @media print {
                .table th {
                    background: #2c5aa0 !important;
                    color: white !important;
                    -webkit-print-color-adjust: exact;
                    print-color-adjust: exact;
                }
                .table {
                    page-break-inside: avoid;
                }
            }
        </style>
    </head>
    <body>
        <!-- Watermark -->
        <div class="watermark">YAKUTECH</div>

        <div class="header">
            <div class="logo-section">
                <?php if ($logoExists && $logoBase64): ?>
                    <img src="data:image/png;base64,<?php echo $logoBase64; ?>" class="logo-image" alt="Yakutech Solutions Limited">
                <?php else: ?>
                    <div class="logo-placeholder">
                        YAKUTECH SOLUTIONS<br>LIMITED
                    </div>
                <?php endif; ?>
                <div style="margin-top: 10px; font-size: 11px; color: #666;">
                    <strong>Technology Solutions & IT Services</strong><br>
                    Transforming Businesses Through Innovation
                </div>
            </div>
            <div class="invoice-info-section">
                <div class="company-name">YAKUTECH SOLUTIONS LIMITED</div>
                <div class="invoice-title"> INVOICE</div>
                <div class="invoice-meta">
                    <div class="meta-grid">
                        <div class="meta-item">
                            <span class="meta-label">Invoice No:</span><br>
                            <?php echo $invoice_number; ?>
                        </div>
                        <div class="meta-item">
                            <span class="meta-label">Date Issued:</span><br>
                            <?php echo date('F j, Y', strtotime($invoice['invoice_date'])); ?>
                        </div>
                        <div class="meta-item">
                            <span class="meta-label">Invoice Type:</span><br>
                            <?php echo strtoupper($invoice['invoice_type']); ?>
                        </div>
                        <div class="meta-item">
                            <span class="meta-label">Status:</span><br>
                            <span style="color: <?php echo $invoice['invoice_status'] == 'paid' ? '#28a745' : '#dc3545'; ?>; font-weight: bold;">
                                <?php echo strtoupper($invoice['invoice_status']); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Rest of your HTML content remains the same -->
        <div class="details-container">
            <div class="section-card">
                <div class="section-title">From</div>
                <strong>Yakutech Solutions Limited</strong><br>
                <strong>PIN:</strong> <?php echo $invoice['company_pin']; ?><br>
                <strong>Email:</strong> Yakutech@gmail.com<br>
                <strong>Phone:</strong> +254 114 524 239<br>
                <strong>Address:</strong> Nairobi, Kenya
            </div>
            <div class="section-card">
                <div class="section-title">Bill To</div>
                <strong><?php echo htmlspecialchars($invoice['customer_name']); ?></strong><br>
                <strong>PIN:</strong> <?php echo $invoice['customer_pin']; ?><br>
                <strong>Email:</strong> <?php echo $invoice['customer_email']; ?><br>
                <strong>Address:</strong> <?php echo htmlspecialchars($invoice['customer_address']); ?><br>
                <?php echo $invoice['customer_city']; ?>, 
                <?php echo $invoice['customer_postal']; ?> - 
                <?php echo $invoice['customer_country']; ?>
            </div>
        </div>

        <?php if (!empty($invoice['lpo_number'])): ?>
        <div style="background: #e7f3ff; padding: 12px; border-radius: 6px; margin: 15px 0; border-left: 4px solid #2c5aa0;">
            <strong style="color: #2c5aa0;">LPO Reference:</strong> <?php echo $invoice['lpo_number']; ?>
        </div>
        <?php endif; ?>

        <div class="table-container">
            <table class="table">
                <thead>
                    <tr>
                        <th width="15%">Item Code</th>
                        <th width="45%">Description</th>
                        <th width="10%" class="text-right">Qty</th>
                        <th width="15%" class="text-right">Unit Price</th>
                        <th width="15%" class="text-right">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $subtotal = 0;
                    if (!empty($invoice_items)):
                        foreach ($invoice_items as $item): 
                            $item_amount = $item['amount'];
                            $subtotal += $item_amount;
                    ?>
                    <tr>
                        <td><?php echo htmlspecialchars($item['item_code']); ?></td>
                        <td><?php echo htmlspecialchars($item['description']); ?></td>
                        <td class="text-right"><?php echo number_format($item['quantity'], 2); ?></td>
                        <td class="text-right">KSh <?php echo number_format($item['rate'], 2); ?></td>
                        <td class="text-right">KSh <?php echo number_format($item_amount, 2); ?></td>
                    </tr>
                    <?php endforeach; 
                    else: ?>
                    <tr>
                        <td colspan="5" class="text-center" style="padding: 30px; color: #666;">
                            No items listed for this invoice
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="amount-summary">
            <table class="summary-table">
                <tr>
                    <td><strong>Subtotal:</strong></td>
                    <td class="text-right">KSh <?php echo number_format($invoice['subtotal'], 2); ?></td>
                </tr>
                <?php if ($invoice['discount_amount'] > 0): ?>
                <tr>
                    <td><strong>Discount (<?php echo $invoice['discount_percentage']; ?>%):</strong></td>
                    <td class="text-right">- KSh <?php echo number_format($invoice['discount_amount'], 2); ?></td>
                </tr>
                <?php endif; ?>
                <?php if ($invoice['vat_amount'] > 0): ?>
                <tr>
                    <td><strong>VAT (<?php echo $invoice['vat_rate']; ?>%):</strong></td>
                    <td class="text-right">KSh <?php echo number_format($invoice['vat_amount'], 2); ?></td>
                </tr>
                <?php endif; ?>
                <tr class="total-row">
                    <td><strong>TOTAL AMOUNT:</strong></td>
                    <td class="text-right total-amount">KSh <?php echo number_format($invoice['total'], 2); ?></td>
                </tr>
            </table>
        </div>

        <?php if (!empty($invoice['terms'])): ?>
        <div class="notes-section">
            <strong>Terms & Conditions:</strong><br>
            <?php echo htmlspecialchars($invoice['terms']); ?>
        </div>
        <?php endif; ?>

        <?php if (!empty($invoice['notes'])): ?>
        <div class="notes-section">
            <strong>Additional Notes:</strong><br>
            <?php echo htmlspecialchars($invoice['notes']); ?>
        </div>
        <?php endif; ?>

        <div class="footer">
            <p style="margin-bottom: 15px;">
                <strong>Thank you for choosing Yakutech Solutions Limited!</strong>
            </p>
            <p style="margin-bottom: 10px;">
                <strong>Yakutech Solutions Limited</strong> | 
                PIN: <?php echo $invoice['company_pin']; ?> | 
                Email: Yakutech@gmail.com | 
                Phone:  +254 114 524 239
            </p>
            <p style="font-size: 10px; color: #999; margin-top: 15px;">
                This is an electronically generated invoice. No signature required.<br>
                If you have any questions concerning this invoice, please contact us.
            </p>
        </div>
    </body>
    </html>
    <?php
    $html = ob_get_clean();

    // Continue with PDF generation and email sending...
    // ... (rest of your existing code for PDF and email)

    // Create PDF
    $dompdf = new Dompdf();
    $dompdf->set_option('isHtml5ParserEnabled', true);
    $dompdf->set_option('isRemoteEnabled', true);
    $dompdf->set_option('defaultFont', 'Helvetica');
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();

    // Save PDF to file
    $pdfOutput = $dompdf->output();
    if (empty($pdfOutput)) {
        throw new Exception("PDF output is empty");
    }

    if (file_put_contents($pdfPath, $pdfOutput) === false) {
        throw new Exception("Failed to save PDF file");
    }

    // Verify PDF was created
    if (!file_exists($pdfPath) || filesize($pdfPath) === 0) {
        throw new Exception("PDF file was not created or is empty");
    }

    // 3. Send email with PDF attachment
    $mail = new PHPMailer(true);

    // SMTP Configuration
    $mail->isSMTP();
    $mail->Host = 'smtp.gmail.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'collinsmunyao61@gmail.com';
    $mail->Password = 'ppzs vhzn rzni abyd';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port = 587;
    $mail->Timeout = 30;
    $mail->SMTPDebug = 0;

    // Email content
    $mail->setFrom('collinsmunyao61@gmail.com', 'Yakutech Solutions Limited');
    $mail->addAddress($invoice['customer_email'], $invoice['customer_name']);
    $mail->addReplyTo('collinsmunyao61@gmail.com', 'Yakutech Solutions Limited');
    
    $mail->Subject = 'Invoice ' . $invoice_number . ' - Yakutech Solutions Limited';
    
    $mail->isHTML(true);
    $mail->Body = "
        <html>
        <body style='font-family: Arial, sans-serif; line-height: 1.6; color: #333;'>
            <div style='background: linear-gradient(135deg, #2c5aa0, #1e3a6b); padding: 30px; text-align: center; color: white;'>
                <h1 style='margin: 0; font-size: 28px;'>YAKUTECH SOLUTIONS LIMITED</h1>
                <p style='margin: 10px 0 0 0; opacity: 0.9;'>Technology Solutions & IT Services</p>
            </div>
            
            <div style='padding: 30px;'>
                <p>Dear <strong style='color: #2c5aa0;'>{$invoice['customer_name']}</strong>,</p>
                
                <p>Please find your official invoice <strong style='color: #d35400;'>{$invoice_number}</strong> attached to this email.</p>
                
                <div style='background: #f8f9fa; padding: 20px; border-radius: 8px; border-left: 4px solid #2c5aa0; margin: 20px 0;'>
                    <h3 style='color: #2c5aa0; margin-top: 0;'>Invoice Summary</h3>
                    <table style='width: 100%;'>
                        <tr>
                            <td style='padding: 8px 0;'><strong>Invoice Number:</strong></td>
                            <td style='padding: 8px 0;'><strong>{$invoice_number}</strong></td>
                        </tr>
                        <tr>
                            <td style='padding: 8px 0;'><strong>Date Issued:</strong></td>
                            <td style='padding: 8px 0;'>" . date('F j, Y', strtotime($invoice['invoice_date'])) . "</td>
                        </tr>
                        <tr>
                            <td style='padding: 8px 0;'><strong>Subtotal:</strong></td>
                            <td style='padding: 8px 0;'>KSh " . number_format($invoice['subtotal'], 2) . "</td>
                        </tr>
                        " . ($invoice['vat_amount'] > 0 ? "
                        <tr>
                            <td style='padding: 8px 0;'><strong>VAT ({$invoice['vat_rate']}%):</strong></td>
                            <td style='padding: 8px 0;'>KSh " . number_format($invoice['vat_amount'], 2) . "</td>
                        </tr>
                        " : "") . "
                        <tr style='border-top: 2px solid #dee2e6;'>
                            <td style='padding: 12px 0;'><strong>Total Amount:</strong></td>
                            <td style='padding: 12px 0;'><strong style='color: #d35400; font-size: 16px;'>KSh " . number_format($invoice['total'], 2) . "</strong></td>
                        </tr>
                    </table>
                </div>
                
                <p>The attached PDF contains the complete invoice with detailed item breakdown, tax information, and payment instructions.</p>
                
                <p>If you have any questions about this invoice or require additional information, please don't hesitate to contact us.</p>
                
                <p>Thank you for your continued trust in Yakutech Solutions Limited.</p>
                
                <div style='margin-top: 40px; padding-top: 20px; border-top: 2px solid #f8f9fa;'>
                    <strong>Yakutech Solutions Limited</strong><br>
                    <span style='color: #666;'>Transforming Businesses Through Innovation</span><br><br>
                    <strong>PIN:</strong> {$invoice['company_pin']}<br>
                    <strong>Email:</strong> Yakutech@gmail.com<br>
                    <strong>Phone:</strong> +254 114 524 239
                </div>
            </div>
        </body>
        </html>
    ";
    
    $mail->AltBody = "INVOICE {$invoice_number} - Yakutech Solutions Limited

Dear {$invoice['customer_name']},

Please find your official tax invoice {$invoice_number} attached.

INVOICE SUMMARY:
- Invoice Number: {$invoice_number}
- Date Issued: " . date('F j, Y', strtotime($invoice['invoice_date'])) . "
- Subtotal: KSh " . number_format($invoice['subtotal'], 2) . "
" . ($invoice['vat_amount'] > 0 ? "- VAT ({$invoice['vat_rate']}%): KSh " . number_format($invoice['vat_amount'], 2) . "\n" : "") . "- Total Amount: KSh " . number_format($invoice['total'], 2) . "

The attached PDF contains the complete invoice with detailed item breakdown and tax information.

Thank you for your business!

Yakutech Solutions Limited
PIN: {$invoice['company_pin']}
Email: Yakutech@gmail.com
Phone: +254 712 345 678";

    // Add PDF attachment
    if (file_exists($pdfPath)) {
        $mail->addAttachment($pdfPath, 'Invoice_' . $invoice_number . '.pdf');
    } else {
        throw new Exception("PDF file not found for attachment: $pdfPath");
    }

    // Send email
    if ($mail->send()) {
        // Store success message in session
        $_SESSION['success_message'] = "✅ Invoice {$invoice_number} sent successfully to {$invoice['customer_email']}";
        
        // Clean up PDF file
        if (file_exists($pdfPath)) {
            unlink($pdfPath);
        }
        
        // Redirect to invoice list
        header('Location: invoice-list.php');
        exit;
        
    } else {
        throw new Exception("Send failed: " . $mail->ErrorInfo);
    }

} catch (Exception $e) {
    // Store error message in session
    $_SESSION['error_message'] = "❌ Error: " . $e->getMessage();
    
    // Clean up PDF file if it exists
    if (isset($pdfPath) && file_exists($pdfPath)) {
        unlink($pdfPath);
    }
    
    // Redirect back to invoice list
    header('Location: invoice-list.php');
    exit;
}
?>