<?php
/*******************************************************************************
*  Invoice Management System                                                *
*                                                                              *
* Version: 1.0	                                                               *
* Developer:  Abhishek Raj                                   				           *
*******************************************************************************/

include('header.php');
include('functions.php');
include_once("includes/config.php");

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Function to safely get sum from database
function getSum($mysqli, $query) {
    $result = mysqli_query($mysqli, $query);
    if (!$result) {
        return 0;
    }
    if (mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        return $row['value_sum'] ? $row['value_sum'] : 0;
    }
    return 0;
}

// Function to safely get count from database
function getCount($mysqli, $query) {
    $result = mysqli_query($mysqli, $query);
    if (!$result) {
        return 0;
    }
    return mysqli_num_rows($result);
}

// Function to check if column exists in table
function columnExists($mysqli, $table, $column) {
    $result = mysqli_query($mysqli, "SHOW COLUMNS FROM $table LIKE '$column'");
    return ($result && mysqli_num_rows($result) > 0);
}

// Check if invoices table has invoice_status column
$has_status_column = columnExists($mysqli, 'invoices', 'invoice_status');
?>

<!-- Small boxes (Stat box) -->
<div class="row">
  <!-- Sales Amount -->
  <div class="col-lg-3 col-xs-6">
    <div class="small-box bg-green">
      <div class="inner">
        <h3>
          <?php 
          if ($has_status_column) {
              $sum_paid = getSum($mysqli, 'SELECT SUM(subtotal) AS value_sum FROM invoices WHERE LOWER(invoice_status) = "paid"');
          } else {
              $sum_paid = getSum($mysqli, 'SELECT SUM(subtotal) AS value_sum FROM invoices');
          }
          echo $sum_paid;
          ?>
        </h3>
        <p>Sales Amount</p>
      </div>
      <div class="icon">
        <i class="ion ion-social-usd"></i>
      </div>
    </div>
  </div>

  <!-- Total Invoices -->
  <div class="col-lg-3 col-xs-6">
    <div class="small-box bg-purple">
      <div class="inner">
        <h3><?php echo getCount($mysqli, "SELECT * FROM invoices"); ?></h3>
        <p>Total Invoices</p>
      </div>
      <div class="icon">
        <i class="ion ion-printer"></i>
      </div>
    </div>
  </div>

  <!-- Pending Bills -->
  <div class="col-lg-3 col-xs-6">
    <div class="small-box bg-yellow">
      <div class="inner">
        <h3>
          <?php 
          if ($has_status_column) {
              $count_open = getCount($mysqli, "SELECT * FROM invoices WHERE LOWER(invoice_status) IN ('open', 'pending')");
          } else {
              $count_open = getCount($mysqli, "SELECT * FROM invoices");
          }
          echo $count_open;
          ?>
        </h3>
        <p>Pending Bills</p>
      </div>
      <div class="icon">
        <i class="ion ion-load-a"></i>
      </div>
    </div>
  </div>

  <!-- Due Amount -->
  <div class="col-lg-3 col-xs-6">
    <div class="small-box bg-red">
      <div class="inner">
        <h3>
          <?php 
          if ($has_status_column) {
              $sum_due = getSum($mysqli, 'SELECT SUM(subtotal) AS value_sum FROM invoices WHERE LOWER(invoice_status) IN ("open", "pending")');
          } else {
              $sum_due = 0;
          }
          echo $sum_due;
          ?>
        </h3>
        <p>Due Amount</p>
      </div>
      <div class="icon">
        <i class="ion ion-alert-circled"></i>
      </div>
    </div>
  </div>
</div>

<!-- Second Row -->
<div class="row">
  <!-- Total Products -->
  <div class="col-lg-3 col-xs-6">
    <div class="small-box bg-primary">
      <div class="inner">
        <h3><?php echo getCount($mysqli, "SELECT * FROM products"); ?></h3>
        <p>Total Products</p>
      </div>
      <div class="icon">
        <i class="ion ion-social-dropbox"></i>
      </div>
    </div>
  </div>

  <!-- Total Customers -->
  <div class="col-lg-3 col-xs-6">
    <div class="small-box bg-maroon">
      <div class="inner">
        <h3>
          <?php 
          $count = getCount($mysqli, "SELECT * FROM store_customers");
          if ($count == 0) {
              $count = getCount($mysqli, "SELECT * FROM customers");
          }
          if ($count == 0) {
              $count = getCount($mysqli, "SELECT * FROM client");
          }
          echo $count;
          ?>
        </h3>
        <p>Total Customers</p>
      </div>
      <div class="icon">
        <i class="ion ion-ios-people"></i>
      </div>
    </div>
  </div>

  <!-- Paid Bills -->
  <div class="col-lg-3 col-xs-6">
    <div class="small-box bg-olive">
      <div class="inner">
        <h3>
          <?php 
          if ($has_status_column) {
              $count_paid = getCount($mysqli, "SELECT * FROM invoices WHERE LOWER(invoice_status) IN ('paid', 'completed')");
          } else {
              $count_paid = getCount($mysqli, "SELECT * FROM invoices");
          }
          echo $count_paid;
          ?>
        </h3>
        <p>Paid Bills</p>
      </div>
      <div class="icon">
        <i class="ion ion-ios-paper"></i>
      </div>
    </div>
  </div>

  <!-- Total Users -->
  <div class="col-lg-3 col-xs-6">
    <div class="small-box bg-teal">
      <div class="inner">
        <h3>
          <?php 
          $users_tables = ['users', 'admin_users', 'system_users', 'admins', 'user', 'admin'];
          $users_count = 0;

          foreach ($users_tables as $table) {
              $result = mysqli_query($mysqli, "SHOW TABLES LIKE '$table'");
              if ($result && mysqli_num_rows($result) > 0) {
                  $users_count = getCount($mysqli, "SELECT * FROM $table");
                  break;
              }
          }
          echo $users_count;
          ?>
        </h3>
        <p>Total Users</p>
      </div>
      <div class="icon">
        <i class="ion ion-person-stalker"></i>
      </div>
    </div>
  </div>
</div>

</section>
<!-- /.content -->

<?php include('footer.php'); ?>
