<?php
include('header.php');
include('functions.php');

// Check for success or error messages from update or delete
$success_message = $_GET['success'] ?? '';
$error_message = $_GET['error'] ?? '';
$redirect_after_update = 'invoice-list.php'; // Change this to your invoice page
?>

<h1>Customer List</h1>
<hr>

<?php if ($success_message): ?>
    <div class="alert alert-success alert-dismissible fade in" id="success-alert">
        <a href="#" class="close" data-dismiss="alert">&times;</a>
        <?php echo htmlspecialchars($success_message); ?>
    </div>
    <script>
        // Fade out and redirect after 3 seconds
        setTimeout(function() {
            $('#success-alert').fadeOut('slow', function() {
                window.location.href = '<?php echo $redirect_after_update; ?>';
            });
        }, 3000);
    </script>
<?php endif; ?>

<?php if ($error_message): ?>
    <div class="alert alert-danger alert-dismissible fade in" id="error-alert">
        <a href="#" class="close" data-dismiss="alert">&times;</a>
        <?php echo htmlspecialchars($error_message); ?>
    </div>
    <script>
        // Fade out error alert after 5 seconds
        setTimeout(function() {
            $('#error-alert').fadeOut('slow');
        }, 5000);
    </script>
<?php endif; ?>

<div class="row">
    <div class="col-xs-12">
        <div id="response" class="alert alert-success" style="display:none;">
            <a href="#" class="close" data-dismiss="alert">&times;</a>
            <div class="message"></div>
        </div>

        <div class="panel panel-default">
            <div class="panel-heading">
                <h4>Customers</h4>
            </div>
            <div class="panel-body form-group form-group-sm">
                <?php getCustomers(); ?>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="delete_customer" class="modal fade">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
        <h4 class="modal-title">Delete Customer</h4>
      </div>
      <div class="modal-body">
        <p>Are you sure you want to delete this customer: <strong id="customer-name"></strong>?</p>
      </div>
      <div class="modal-footer">
        <a href="#" class="btn btn-danger" id="confirm-delete">Delete</a>
        <button type="button" data-dismiss="modal" class="btn">Cancel</button>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<script>
$(document).ready(function() {
    // Show modal with customer name
    $('.delete-customer').click(function(e) {
        e.preventDefault();
        var name = $(this).data('customer-name');
        var id = $(this).data('customer-id');

        $('#customer-name').text(name);
        $('#confirm-delete').attr('href', 'customer-delete.php?id=' + id + '&success=Customer+' + encodeURIComponent(name) + '+deleted+successfully');
        $('#delete_customer').modal('show');
    });

    // Auto fade alerts
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>

<?php
include('footer.php');
?>
