<?php
include('header.php');
include('functions.php');

// Get customer ID from URL and validate
$getID = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($getID <= 0) {
    die("<div class='alert alert-danger'>Invalid customer ID!</div>");
}

// Initialize variables
$customer_name = $customer_email = $customer_address = $customer_city = "";
$customer_postal = $customer_country = $customer_phone = $customer_pin = "";
$success_message = $error_message = "";

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $customer_name = $_POST['customer_name'] ?? '';
    $customer_email = $_POST['customer_email'] ?? '';
    $customer_address = $_POST['customer_address'] ?? '';
    $customer_city = $_POST['customer_city'] ?? '';
    $customer_postal = $_POST['customer_postal'] ?? '';
    $customer_country = $_POST['customer_country'] ?? '';
    $customer_phone = $_POST['customer_phone'] ?? '';
    $customer_pin = $_POST['customer_pin'] ?? '';

    // Validate required fields
    if (empty($customer_name) || empty($customer_email) || empty($customer_address)) {
        $error_message = "Please fill all required fields (Name, Email, and Address).";
    } else {
        $mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);
        if ($mysqli->connect_error) {
            die('Database Connection Error: ' . $mysqli->connect_error);
        }

        // Update customer record
        $stmt = $mysqli->prepare("UPDATE `customers` SET 
            `customer_name` = ?, `customer_email` = ?, `customer_address` = ?, 
            `customer_city` = ?, `customer_postal` = ?, `customer_country` = ?, 
            `customer_phone` = ?, `customer_pin` = ? WHERE id = ?");

        if ($stmt === false) {
            $error_message = "Database preparation error: " . $mysqli->error;
        } else {
            $stmt->bind_param(
                "ssssssssi",
                $customer_name, $customer_email, $customer_address,
                $customer_city, $customer_postal, $customer_country,
                $customer_phone, $customer_pin, $getID
            );

            if ($stmt->execute()) {
                $success_message = "Customer updated successfully!";
            } else {
                if ($stmt->errno == 1062) {
                    $error_message = "A customer with this email already exists.";
                } else {
                    $error_message = "Database error: " . $stmt->error;
                }
            }

            $stmt->close();
        }
        $mysqli->close();
    }
}

// Fetch customer data for display
$mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);
if ($mysqli->connect_error) {
    die('Database connection error: ' . $mysqli->connect_error);
}

$stmt = $mysqli->prepare("SELECT * FROM `customers` WHERE id = ?");
$stmt->bind_param("i", $getID);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();

    $customer_name = $customer_name ?: $row['customer_name'];
    $customer_email = $customer_email ?: $row['customer_email'];
    $customer_address = $customer_address ?: $row['customer_address'];
    $customer_city = $customer_city ?: $row['customer_city'];
    $customer_postal = $customer_postal ?: $row['customer_postal'];
    $customer_country = $customer_country ?: $row['customer_country'];
    $customer_phone = $customer_phone ?: $row['customer_phone'];
    $customer_pin = $customer_pin ?: $row['customer_pin'];
} else {
    die("<div class='alert alert-danger'>Customer not found!</div>");
}

$stmt->close();
$mysqli->close();
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading bg-primary text-white">
                    <h3 class="panel-title"><i class="glyphicon glyphicon-edit"></i> Edit Customer</h3>
                </div>
                <div class="panel-body">

                    <?php if ($success_message): ?>
                        <div class='alert alert-success'><?php echo $success_message; ?></div>
                    <?php endif; ?>

                    <?php if ($error_message): ?>
                        <div class='alert alert-danger'><?php echo $error_message; ?></div>
                    <?php endif; ?>

                    <form method="post" id="edit_customer">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="required">Customer Name</label>
                                    <input type="text" class="form-control required-field" name="customer_name" 
                                           value="<?php echo htmlspecialchars($customer_name); ?>" required>
                                </div>
                                <div class="form-group">
                                    <label class="required">Email</label>
                                    <input type="email" class="form-control required-field" name="customer_email" 
                                           value="<?php echo htmlspecialchars($customer_email); ?>" required>
                                </div>
                                <div class="form-group">
                                    <label>Phone Number</label>
                                    <input type="text" class="form-control" name="customer_phone" 
                                           value="<?php echo htmlspecialchars($customer_phone); ?>">
                                </div>
                                <div class="form-group">
                                    <label>Customer PIN</label>
                                    <input type="text" class="form-control" name="customer_pin" 
                                           value="<?php echo htmlspecialchars($customer_pin); ?>">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="required">Address</label>
                                    <textarea class="form-control required-field" name="customer_address" rows="3" required><?php echo htmlspecialchars($customer_address); ?></textarea>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>City</label>
                                            <input type="text" class="form-control" name="customer_city" 
                                                   value="<?php echo htmlspecialchars($customer_city); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Postal Code</label>
                                            <input type="text" class="form-control" name="customer_postal" 
                                                   value="<?php echo htmlspecialchars($customer_postal); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Country</label>
                                    <input type="text" class="form-control" name="customer_country" 
                                           value="<?php echo htmlspecialchars($customer_country ?: 'Kenya'); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 text-right">
                                <hr>
                                <button type="submit" class="btn btn-success btn-lg"><i class="glyphicon glyphicon-floppy-disk"></i> Update Customer</button>
                                <a href="customer-list.php" class="btn btn-default btn-lg">Cancel</a>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Form validation
    $('#edit_customer').on('submit', function(e) {
        let valid = true;
        $('.required-field').removeClass('is-invalid');

        $('.required-field').each(function() {
            if ($(this).val().trim() === '') {
                valid = false;
                $(this).addClass('is-invalid');
            }
        });

        const emailField = $('input[name="customer_email"]');
        const emailValue = emailField.val().trim();
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

        if (emailValue !== '' && !emailPattern.test(emailValue)) {
            valid = false;
            emailField.addClass('is-invalid');
            alert('Please enter a valid email address.');
        }

        if (!valid) {
            e.preventDefault();
            alert('Please fill in all required fields marked with *.');
            return false;
        }
        return true;
    });

    // Remove invalid class when user types
    $('.required-field').on('input', function() {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('is-invalid');
        }
    });

    // Fade out alerts
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>

<?php include('footer.php'); ?>
