<?php
include('header.php');
include('functions.php');

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Customer info - using exact database column names
    $customer_name = $_POST['customer_name'] ?? '';
    $customer_email = $_POST['customer_email'] ?? '';
    $customer_address = $_POST['customer_address'] ?? '';
    $customer_city = $_POST['customer_city'] ?? '';
    $customer_postal = $_POST['customer_postal'] ?? '';
    $customer_country = $_POST['customer_country'] ?? '';
    $customer_phone = $_POST['customer_phone'] ?? '';
    $customer_pin = $_POST['customer_pin'] ?? '';

    // Validate required fields
    if (empty($customer_name) || empty($customer_email) || empty($customer_address)) {
        echo "<div class='alert alert-danger'>
                <a href='#' class='close' data-dismiss='alert'>&times;</a>
                Please fill all required fields (Name, Email, and Address).
              </div>";
    } else {
        $mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);
        if ($mysqli->connect_error) {
            die('Database Connection Error: ' . $mysqli->connect_error);
        }

        // Insert into customers table with exact column names
        $stmt = $mysqli->prepare("INSERT INTO `customers` 
            (`customer_name`, `customer_email`, `customer_address`, `customer_city`, 
             `customer_postal`, `customer_country`, `customer_phone`, `customer_pin`, `date_created`)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())");

        // Check if prepare was successful
        if ($stmt === false) {
            echo "<div class='alert alert-danger'>
                    <a href='#' class='close' data-dismiss='alert'>&times;</a>
                    Database preparation error: " . $mysqli->error . "
                  </div>";
        } else {
            $stmt->bind_param(
                "ssssssss",
                $customer_name, $customer_email, $customer_address, $customer_city, 
                $customer_postal, $customer_country, $customer_phone, $customer_pin
            );

            if ($stmt->execute()) {
                echo "<div class='alert alert-success'>
                        <a href='#' class='close' data-dismiss='alert'>&times;</a>
                        Customer added successfully!
                      </div>";
                
                // Clear form after successful submission
                $customer_name = $customer_email = $customer_address = $customer_city = 
                $customer_postal = $customer_country = $customer_phone = $customer_pin = '';
            } else {
                // Check for duplicate email error
                if ($stmt->errno == 1062) {
                    echo "<div class='alert alert-danger'>
                            <a href='#' class='close' data-dismiss='alert'>&times;</a>
                            Error: A customer with this email address already exists.
                          </div>";
                } else {
                    echo "<div class='alert alert-danger'>
                            <a href='#' class='close' data-dismiss='alert'>&times;</a>
                            Database error: " . $stmt->error . "
                          </div>";
                }
            }

            $stmt->close();
        }
        $mysqli->close();
    }
}
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading bg-primary text-white">
                    <h3 class="panel-title">
                        <i class="glyphicon glyphicon-user"></i> Add New Customer
                    </h3>
                </div>
                <div class="panel-body">
                    <form method="post" id="create_customer">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="required">Customer Name</label>
                                    <input type="text" class="form-control required-field" name="customer_name" 
                                           value="<?php echo htmlspecialchars($customer_name ?? ''); ?>" 
                                           placeholder="Enter Customer Name" required>
                                </div>
                                
                                <div class="form-group">
                                    <label class="required">Email Address</label>
                                    <input type="email" class="form-control required-field" name="customer_email" 
                                           value="<?php echo htmlspecialchars($customer_email ?? ''); ?>" 
                                           placeholder="Enter Email Address" required>
                                </div>
                                
                                <div class="form-group">
                                    <label>Phone Number</label>
                                    <input type="text" class="form-control" name="customer_phone" 
                                           value="<?php echo htmlspecialchars($customer_phone ?? ''); ?>" 
                                           placeholder="Enter Phone Number">
                                </div>
                                
                                <div class="form-group">
                                    <label>Customer PIN</label>
                                    <input type="text" class="form-control" name="customer_pin" 
                                           value="<?php echo htmlspecialchars($customer_pin ?? ''); ?>" 
                                           placeholder="Enter Customer PIN">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="required">Address</label>
                                    <textarea class="form-control required-field" name="customer_address" rows="3" 
                                              placeholder="Enter Full Address" required><?php echo htmlspecialchars($customer_address ?? ''); ?></textarea>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>City</label>
                                            <input type="text" class="form-control" name="customer_city" 
                                                   value="<?php echo htmlspecialchars($customer_city ?? ''); ?>" 
                                                   placeholder="Enter City">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Postal Code</label>
                                            <input type="text" class="form-control" name="customer_postal" 
                                                   value="<?php echo htmlspecialchars($customer_postal ?? ''); ?>" 
                                                   placeholder="Enter Postal Code">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label>Country</label>
                                    <input type="text" class="form-control" name="customer_country" 
                                           value="<?php echo htmlspecialchars($customer_country ?? 'Kenya'); ?>" 
                                           placeholder="Enter Country">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <hr>
                                <div class="text-right">
                                    <button type="submit" class="btn btn-success btn-lg">
                                        <i class="glyphicon glyphicon-floppy-disk"></i> Create Customer
                                    </button>
                                    <a href="customers.php" class="btn btn-default btn-lg">Cancel</a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.panel-heading {
    background: linear-gradient(135deg, #663399, #8A2BE2) !important;
    border: none !important;
    color: white;
}

.required:after {
    content: " *";
    color: red;
}

.form-control {
    border-radius: 4px;
    border: 1px solid #ddd;
    padding: 10px 12px;
    transition: border-color 0.3s ease;
}

.form-control:focus {
    border-color: #663399;
    box-shadow: 0 0 0 0.2rem rgba(102, 51, 153, 0.25);
}

.btn-success {
    background: linear-gradient(135deg, #28a745, #20c997);
    border: none;
    border-radius: 6px;
    padding: 10px 30px;
    font-weight: 600;
}

.btn-success:hover {
    background: linear-gradient(135deg, #218838, #1e7e34);
    transform: translateY(-2px);
}

.alert {
    border-radius: 8px;
    border: none;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.is-invalid {
    border-color: #dc3545 !important;
    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important;
}
</style>

<script>
$(document).ready(function() {
    // Form validation
    $('#create_customer').on('submit', function(e) {
        let valid = true;
        $('.required-field').removeClass('is-invalid');

        $('.required-field').each(function() {
            if ($(this).val().trim() === '') {
                valid = false;
                $(this).addClass('is-invalid');
            }
        });

        const emailField = $('input[name="customer_email"]');
        const emailValue = emailField.val().trim();
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

        if (emailValue !== '' && !emailPattern.test(emailValue)) {
            valid = false;
            emailField.addClass('is-invalid');
            alert('Please enter a valid email address.');
        }

        if (!valid) {
            e.preventDefault();
            alert('Please fill in all required fields marked with *.');
            return false;
        }

        return true;
    });

    // Remove invalid class when user types
    $('.required-field').on('input', function() {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('is-invalid');
        }
    });

    // Fade out alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>


<?php include('footer.php'); ?>