<?php
$page_title = 'All Product';
require_once('includes/load.php');
page_require_level(2);

// Handle search query
$search = $_GET['q'] ?? '';

$sql  = "SELECT p.id, p.name, p.quantity, p.buy_price, p.sale_price, ";
$sql .= "p.date, c.name AS categorie, m.file_name AS image, p.barcode, p.media_id ";
$sql .= "FROM products p ";
$sql .= "LEFT JOIN categories c ON c.id = p.categorie_id ";
$sql .= "LEFT JOIN media m ON m.id = p.media_id ";

if (!empty($search)) {
    $search = $db->escape($search);
    $sql .= " WHERE p.name LIKE '%{$search}%' OR p.barcode LIKE '%{$search}%'";
}

$sql .= " ORDER BY p.quantity ASC"; // Sort by quantity to show low stock first

$products = find_by_sql($sql);
if ($products === false) {
    echo "SQL Error: " . $db->error;
    exit;
}

// If it's an AJAX request → return only <tr> rows
if (isset($_GET['ajax'])) {
    $count = 1;
    foreach ($products as $product) {
        $quantity = (int)$product['quantity'];
        $stock_class = '';
        $stock_icon = '';
        
        // Determine stock status
        if ($quantity == 0) {
            $stock_class = 'danger';
            $stock_icon = '<span class="glyphicon glyphicon-exclamation-sign text-danger" title="Out of Stock"></span>';
        } elseif ($quantity < 5) {
            $stock_class = 'warning';
            $stock_icon = '<span class="glyphicon glyphicon-warning-sign text-danger" title="Low Stock"></span>';
        } elseif ($quantity < 10) {
            $stock_class = 'info';
            $stock_icon = '<span class="glyphicon glyphicon-info-sign text-warning" title="Medium Stock"></span>';
        } else {
            $stock_class = 'success';
            $stock_icon = '<span class="glyphicon glyphicon-ok-sign text-success" title="Good Stock"></span>';
        }
        
        echo '<tr>';
        echo '<td class="text-center">'. $count++ .'</td>';
        echo '<td>';
        if ($product['media_id'] === '0') {
            echo '<img class="img-thumbnail img-circle" src="uploads/products/no_image.png" style="width:50px;height:50px;" alt="">';
        } else {
            echo '<img class="img-thumbnail img-circle" src="uploads/products/'.$product['image'].'" style="width:50px;height:50px;" alt="">';
        }
        echo '</td>';
        echo '<td>'.remove_junk($product['barcode']).'</td>';
        echo '<td>'.remove_junk($product['name']).'</td>';
        echo '<td class="text-center">'.remove_junk($product['categorie']).'</td>';
        echo '<td class="text-center stock-cell '.$stock_class.'">';
        echo $stock_icon . ' ' . remove_junk($product['quantity']);
        echo '</td>';
        echo '<td class="text-center">'.remove_junk($product['buy_price']).'</td>';
        echo '<td class="text-center">'.remove_junk($product['sale_price']).'</td>';
        echo '<td class="text-center">'.read_date($product['date']).'</td>';
        echo '<td class="text-center">
                <div class="btn-group btn-group-sm">
                    <a href="edit_product.php?id='.(int)$product['id'].'" class="btn btn-info" title="Edit">
                        <span class="glyphicon glyphicon-edit"></span>
                    </a>';
        
        // Only show delete button if quantity is 0 (to prevent deleting products with stock)
        if ($quantity == 0) {
            echo '<a href="delete_product.php?id='.(int)$product['id'].'" class="btn btn-danger" title="Delete">
                    <span class="glyphicon glyphicon-trash"></span>
                  </a>';
        } else {
            echo '<button class="btn btn-danger" disabled title="Cannot delete - Product has stock">
                    <span class="glyphicon glyphicon-trash"></span>
                  </button>';
        }
        
        echo '</div>
              </td>';
        echo '</tr>';
    }
    exit; // stop rendering rest of the page
}
?>
<?php include_once('layouts/header.php'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <?php echo display_msg($msg); ?>
        </div>
        <div class="col-md-12">
            <div class="panel panel-default shadow-sm">
                <div class="panel-heading d-flex justify-content-between align-items-center clearfix">
                    <div class="pull-left">
                        <form id="search-form" class="form-inline">
                            <div class="form-group">
                                <input type="text" id="search-box" name="q" 
                                       class="form-control" 
                                       placeholder="Search product..." 
                                       value="<?php echo htmlentities($search); ?>">
                            </div>
                            <button type="submit" class="btn btn-primary">
                                <span class="glyphicon glyphicon-search"></span> Search
                            </button>
                        </form>
                    </div>
                    <div class="pull-right">
                        <a href="add_product.php" class="btn btn-success">
                            <span class="glyphicon glyphicon-plus"></span> Add New
                        </a>
                        <button id="low-stock-filter" class="btn btn-warning">
                            <span class="glyphicon glyphicon-warning-sign"></span> Show Low Stock
                        </button>
                    </div>
                </div>

                <div class="panel-body">
                    <!-- Stock Status Legend -->
                    <div class="stock-legend mb-3">
                        <span class="legend-item">
                            <span class="glyphicon glyphicon-ok-sign text-success"></span> Good Stock (10+)
                        </span>
                        <span class="legend-item">
                            <span class="glyphicon glyphicon-info-sign text-warning"></span> Medium Stock (5-9)
                        </span>
                        <span class="legend-item">
                            <span class="glyphicon glyphicon-warning-sign text-danger"></span> Low Stock (1-4)
                        </span>
                        <span class="legend-item">
                            <span class="glyphicon glyphicon-exclamation-sign text-danger"></span> Out of Stock (0)
                        </span>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover">
                            <thead class="thead-dark">
                                <tr>
                                    <th class="text-center" style="width: 50px;">#</th>
                                    <th>Photo</th>
                                    <th class="text-center" style="width: 10%;">Barcode</th>
                                    <th>Product Title</th>
                                    <th class="text-center" style="width: 10%;">Category</th>
                                    <th class="text-center" style="width: 12%;">In-Stock</th>
                                    <th class="text-center" style="width: 10%;">Buying Price</th>
                                    <th class="text-center" style="width: 10%;">Selling Price</th>
                                    <th class="text-center" style="width: 10%;">Date Added</th>
                                    <th class="text-center" style="width: 100px;">Actions</th>
                                </tr>
                            </thead>
                            <tbody id="products-table-body">
                                <?php $count = 1; ?>
                                <?php foreach ($products as $product): ?>
                                <?php
                                $quantity = (int)$product['quantity'];
                                $stock_class = '';
                                $stock_icon = '';
                                
                                // Determine stock status
                                if ($quantity == 0) {
                                    $stock_class = 'danger';
                                    $stock_icon = '<span class="glyphicon glyphicon-exclamation-sign text-danger" title="Out of Stock"></span>';
                                } elseif ($quantity < 5) {
                                    $stock_class = 'warning';
                                    $stock_icon = '<span class="glyphicon glyphicon-warning-sign text-danger" title="Low Stock"></span>';
                                } elseif ($quantity < 10) {
                                    $stock_class = 'info';
                                    $stock_icon = '<span class="glyphicon glyphicon-info-sign text-warning" title="Medium Stock"></span>';
                                } else {
                                    $stock_class = 'success';
                                    $stock_icon = '<span class="glyphicon glyphicon-ok-sign text-success" title="Good Stock"></span>';
                                }
                                ?>
                                <tr class="stock-row" data-quantity="<?php echo $quantity; ?>">
                                    <td class="text-center"><?php echo $count++; ?></td>
                                    <td>
                                        <?php if($product['media_id'] === '0'): ?>
                                            <img class="img-thumbnail img-circle" src="uploads/products/no_image.png" style="width:50px;height:50px;" alt="">
                                        <?php else: ?>
                                            <img class="img-thumbnail img-circle" src="uploads/products/<?php echo $product['image']; ?>" style="width:50px;height:50px;" alt="">
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo remove_junk($product['barcode']); ?></td>
                                    <td><?php echo remove_junk($product['name']); ?></td>
                                    <td class="text-center"><?php echo remove_junk($product['categorie']); ?></td>
                                    <td class="text-center stock-cell <?php echo $stock_class; ?>">
                                        <?php echo $stock_icon . ' ' . remove_junk($product['quantity']); ?>
                                    </td>
                                    <td class="text-center"><?php echo remove_junk($product['buy_price']); ?></td>
                                    <td class="text-center"><?php echo remove_junk($product['sale_price']); ?></td>
                                    <td class="text-center"><?php echo read_date($product['date']); ?></td>
                                    <td class="text-center">
                                        <div class="btn-group btn-group-sm">
                                            <a href="edit_product.php?id=<?php echo (int)$product['id'];?>" class="btn btn-info" title="Edit">
                                                <span class="glyphicon glyphicon-edit"></span>
                                            </a>
                                            <?php if ($quantity == 0): ?>
                                                <a href="delete_product.php?id=<?php echo (int)$product['id'];?>" class="btn btn-danger" title="Delete">
                                                    <span class="glyphicon glyphicon-trash"></span>
                                                </a>
                                            <?php else: ?>
                                                <button class="btn btn-danger" disabled title="Cannot delete - Product has stock">
                                                    <span class="glyphicon glyphicon-trash"></span>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div> <!-- /.table-responsive -->
                </div> <!-- /.panel-body -->
            </div>
        </div>
    </div>
</div>

<?php include_once('layouts/footer.php'); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function(){
    function fetchProducts(query = '') {
        $.ajax({
            url: window.location.href,
            type: 'GET',
            data: { q: query, ajax: 1 },
            success: function(data) {
                $('#products-table-body').html(data);
            },
            error: function(xhr, status, error) {
                console.error("Error fetching products:", error);
            }
        });
    }

    let searchTimeout;
    $('#search-box').on('keyup', function(){
        clearTimeout(searchTimeout);
        const searchValue = $(this).val();
        searchTimeout = setTimeout(function() {
            fetchProducts(searchValue);
        }, 300);
    });

    $('#search-form').on('submit', function(e){
        e.preventDefault();
        fetchProducts($('#search-box').val());
    });

    // Low stock filter
    $('#low-stock-filter').on('click', function(){
        const $rows = $('.stock-row');
        const $button = $(this);
        
        if ($button.hasClass('active')) {
            // Show all rows
            $rows.show();
            $button.removeClass('active').removeClass('btn-danger').addClass('btn-warning');
            $button.html('<span class="glyphicon glyphicon-warning-sign"></span> Show Low Stock');
        } else {
            // Show only low stock rows (quantity < 5)
            $rows.each(function() {
                const quantity = parseInt($(this).data('quantity'));
                if (quantity < 5) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
            $button.addClass('active').removeClass('btn-warning').addClass('btn-danger');
            $button.html('<span class="glyphicon glyphicon-list"></span> Show All');
        }
    });
});
</script>

<style>
.stock-cell {
    font-weight: bold;
}

.stock-cell.success {
    background-color: #d4edda !important;
    color: #155724;
}

.stock-cell.info {
    background-color: #d1ecf1 !important;
    color: #0c5460;
}

.stock-cell.warning {
    background-color: #fff3cd !important;
    color: #856404;
}

.stock-cell.danger {
    background-color: #f8d7da !important;
    color: #721c24;
}

.stock-legend {
    background: #f8f9fa;
    padding: 10px;
    border-radius: 5px;
    border: 1px solid #dee2e6;
}

.legend-item {
    margin-right: 20px;
    font-size: 14px;
}

.legend-item .glyphicon {
    margin-right: 5px;
}

.btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
}

/* Highlight low stock rows */
.stock-row[data-quantity="0"] {
    border-left: 4px solid #dc3545;
}

.stock-row[data-quantity*="1"],
.stock-row[data-quantity*="2"], 
.stock-row[data-quantity*="3"],
.stock-row[data-quantity*="4"] {
    border-left: 4px solid #ffc107;
}
</style>