<?php
  $page_title = 'Monthly Sales';
  require_once('includes/load.php');
  // Checkin What level user has permission to view this page
   page_require_level(3);
?>
<?php
 $year = date('Y');
 $sales = monthlySales($year);
?>
<?php include_once('layouts/header.php'); ?>

<style>
@media print {
    body * {
        visibility: hidden;
    }
    .print-section, .print-section * {
        visibility: visible;
    }
    .print-section {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
    }
    .no-print {
        display: none !important;
    }
    .table {
        border-collapse: collapse;
        width: 100%;
        font-size: 12px;
    }
    .table th, .table td {
        border: 1px solid #ddd;
        padding: 6px;
    }
    .table th {
        background-color: #f2f2f2;
        color: #000;
    }
    .print-header {
        text-align: center;
        margin-bottom: 15px;
    }
    .print-footer {
        margin-top: 30px;
        text-align: center;
        font-size: 12px;
    }
    .print-summary {
        margin: 15px 0;
        padding: 10px;
        background-color: #f9f9f9;
        border: 1px solid #ddd;
    }
}
</style>

<div class="row">
  <div class="col-md-6">
    <?php echo display_msg($msg); ?>
  </div>
</div>
<div class="row">
  <div class="col-md-12">
    <div class="panel panel-default print-section">
      <div class="panel-heading clearfix">
        <div class="pull-left">
          <strong>
            <span class="glyphicon glyphicon-th"></span>
            <span>Monthly Sales</span>
          </strong>
        </div>
        <div class="pull-right">
          <div class="form-inline">
            <div class="input-group">
              <input type="text" id="search-input" class="form-control" placeholder="Search products...">
              <div class="input-group-btn">
                <button id="clear-search" class="btn btn-default" style="display: none;">
                  <span class="glyphicon glyphicon-remove"></span>
                </button>
              </div>
            </div>
            <button id="print-btn" class="btn btn-primary" style="margin-left: 10px;">
              <span class="glyphicon glyphicon-print"></span> Print
            </button>
          </div>
        </div>
      </div>
      <div class="panel-body">
        <!-- Printable Header (hidden by default) -->
        <div class="print-header" style="display: none;">
          <h2>MUWAKA ENTERPRISE</h2>
          <h3>Monthly Sales Report - <?php echo date('F Y'); ?></h3>
          <p>Generated on: <?php echo date('Y-m-d H:i:s'); ?></p>
        </div>
        
        <div id="search-results-info" class="alert alert-info" style="display: none;">
          Showing <span id="results-count">0</span> results for "<span id="search-term"></span>"
        </div>
        
        <table class="table table-bordered table-striped">
          <thead>
            <tr>
              <th class="text-center" style="width: 50px;">#</th>
              <th> Product name </th>
              <th class="text-center" style="width: 15%;"> Quantity sold</th>
              <th class="text-center" style="width: 15%;"> Total </th>
              <th class="text-center" style="width: 15%;"> Date </th>
            </tr>
          </thead>
          <tbody id="sales-table-body">
            <?php 
            $counter = 1; 
            $total_quantity = 0;
            $total_revenue = 0;
            ?>
            <?php foreach ($sales as $sale): ?>
            <tr>
              <td class="text-center"><?php echo $counter++; ?></td>
              <td class="product-name"><?php echo remove_junk($sale['name']); ?></td>
              <td class="text-center"><?php echo (int)$sale['total_sales']; ?></td>
              <td class="text-center"><?php echo remove_junk($sale['total_saleing_price']); ?></td>
              <td class="text-center"><?php echo $sale['date']; ?></td>
            </tr>
            <?php 
            $total_quantity += (int)$sale['total_sales'];
            $total_revenue += (float)$sale['total_saleing_price'];
            ?>
            <?php endforeach; ?>
          </tbody>
          <tfoot>
            <tr style="font-weight: bold; background-color: #f8f9fa;">
              <td colspan="2" class="text-right">TOTALS:</td>
              <td class="text-center"><?php echo $total_quantity; ?></td>
              <td class="text-center"><?php echo number_format($total_revenue, 2); ?></td>
              <td></td>
            </tr>
          </tfoot>
        </table>
        
        <!-- Printable Summary (hidden by default) -->
        <div class="print-summary" style="display: none;">
          <div class="row">
            <div class="col-md-4">
              <strong>Total Products Sold:</strong> <?php echo $total_quantity; ?>
            </div>
            <div class="col-md-4">
              <strong>Total Revenue:</strong> Ksh <?php echo number_format($total_revenue, 2); ?>
            </div>
            <div class="col-md-4">
              <strong>Total Transactions:</strong> <?php echo count($sales); ?>
            </div>
          </div>
        </div>
        
        <!-- Printable Footer (hidden by default) -->
        <div class="print-footer" style="display: none;">
          <div style="float: left; width: 45%;">
            <p>_________________________</p>
            <p>Cashier's Signature</p>
          </div>
          <div style="float: right; width: 45%; text-align: right;">
            <p>_________________________</p>
            <p>Manager's Signature</p>
          </div>
          <div style="clear: both;"></div>
          <p style="margin-top: 20px;">This is a computer-generated report. No signature is required.</p>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const searchInput = document.getElementById('search-input');
  const clearSearch = document.getElementById('clear-search');
  const salesTableBody = document.getElementById('sales-table-body');
  const searchResultsInfo = document.getElementById('search-results-info');
  const resultsCount = document.getElementById('results-count');
  const searchTerm = document.getElementById('search-term');
  const printBtn = document.getElementById('print-btn');
  
  const originalRows = Array.from(salesTableBody.querySelectorAll('tr'));
  
  // Function to filter rows based on search term
  function filterRows(searchValue) {
    const searchLower = searchValue.toLowerCase();
    let visibleCount = 0;
    
    originalRows.forEach(row => {
      const productName = row.querySelector('.product-name').textContent.toLowerCase();
      const isVisible = productName.includes(searchLower);
      
      row.style.display = isVisible ? '' : 'none';
      if (isVisible) visibleCount++;
    });
    
    // Update results info
    if (searchValue) {
      searchResultsInfo.style.display = '';
      resultsCount.textContent = visibleCount;
      searchTerm.textContent = searchValue;
      clearSearch.style.display = '';
    } else {
      searchResultsInfo.style.display = 'none';
      clearSearch.style.display = 'none';
    }
  }
  
  // Event listener for search input
  searchInput.addEventListener('input', function() {
    filterRows(this.value);
  });
  
  // Clear search button
  clearSearch.addEventListener('click', function() {
    searchInput.value = '';
    filterRows('');
    searchInput.focus();
  });
  
  // Print functionality
  printBtn.addEventListener('click', function() {
    // Show printable elements
    document.querySelectorAll('.print-header, .print-summary, .print-footer').forEach(function(el) {
        el.style.display = 'block';
    });
    
    // Hide non-printable elements
    document.querySelectorAll('.no-print').forEach(function(el) {
        el.style.display = 'none';
    });
    
    // Hide search elements when printing
    searchInput.style.display = 'none';
    clearSearch.style.display = 'none';
    printBtn.style.display = 'none';
    searchResultsInfo.style.display = 'none';
    
    // Wait a moment before printing to allow DOM to update
    setTimeout(function() {
        window.print();
        
        // Revert changes after printing
        setTimeout(function() {
            document.querySelectorAll('.print-header, .print-summary, .print-footer').forEach(function(el) {
                el.style.display = 'none';
            });
            document.querySelectorAll('.no-print').forEach(function(el) {
                el.style.display = '';
            });
            
            searchInput.style.display = '';
            printBtn.style.display = '';
            if (searchInput.value) {
                clearSearch.style.display = '';
                searchResultsInfo.style.display = '';
            }
        }, 500);
    }, 100);
  });
});
</script>

<style>
#search-input {
  transition: all 0.3s ease;
}

#search-input:focus {
  border-color: #66afe9;
  outline: 0;
  box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102, 175, 233, 0.6);
}

#clear-search {
  transition: all 0.3s ease;
}

#search-results-info {
  transition: all 0.3s ease;
}

#print-btn {
  margin-left: 10px;
}
</style>

<?php include_once('layouts/footer.php'); ?>