<?php
ob_start();
require_once('includes/load.php');

// Redirect if already logged in
if ($session->isUserLoggedIn(true)) { 
    redirect('home.php', false);
}
?>
<?php include_once('layouts/header.php'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - MUWAKA ENTERPRISE</title>
    <!-- Load Font Awesome from CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        html, body {
            height: 100%;
            overflow: hidden; /* Prevent scrolling */
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.8)), 
                       url('https://images.unsplash.com/photo-1607082348824-0a96f2a4b9da?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1770&q=80') no-repeat center center fixed;
            background-size: cover;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            overflow: hidden; /* Prevent body scrolling */
        }
        
        .login-wrapper {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 100%;
            height: 100%;
            overflow: hidden; /* Prevent wrapper scrolling */
        }
        
        .login-container {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.3);
            width: 90%;
            max-width: 900px;
            max-height: 500px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            animation: slideUp 0.8s ease-out;
            display: flex;
            overflow: hidden; /* Prevent container scrolling */
        }
        
        @keyframes slideUp {
            from { 
                opacity: 0; 
                transform: translateY(30px); 
            }
            to { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }
        
        .image-section {
            flex: 1;
            background: linear-gradient(rgba(217, 83, 79, 0.8), rgba(201, 48, 44, 0.8)), 
                        url('https://images.unsplash.com/photo-1556742049-0cfed4f6a45d?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=774&q=80') no-repeat center center;
            background-size: cover;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 30px;
            color: white;
            text-align: center;
            position: relative;
        }
        
        .image-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.3);
            z-index: 1;
        }
        
        .image-content {
            position: relative;
            z-index: 2;
        }
        
        .brand-logo {
            width: 80px;
            height: 80px;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 50%;
            margin: 0 auto 15px;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 32px;
            color: #d9534f;
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.2);
        }
        
        .brand-name {
            font-size: 28px;
            font-weight: 800;
            margin-bottom: 8px;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.3);
        }
        
        .brand-subtitle {
            font-size: 16px;
            margin-bottom: 20px;
            font-weight: 500;
            opacity: 0.9;
        }
        
        .feature-list {
            list-style: none;
            margin-top: 25px;
        }
        
        .feature-list li {
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            font-size: 14px;
            font-weight: 500;
        }
        
        .feature-list i {
            margin-right: 10px;
            background: rgba(255, 255, 255, 0.2);
            width: 24px;
            height: 24px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
        }
        
        .form-section {
            flex: 1;
            padding: 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            overflow-y: auto;
        }
        
        .form-section h2 {
            color: #333;
            margin-bottom: 25px;
            font-size: 24px;
            font-weight: 700;
            text-align: center;
        }
        
        .form-group {
            margin-bottom: 20px;
            position: relative;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 6px;
            font-weight: 600;
            color: #444;
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 0.8px;
        }
        
        .input-with-icon {
            position: relative;
        }
        
        .form-control {
            width: 100%;
            padding: 12px 12px 12px 40px;
            border: 1.5px solid #e1e5e9;
            border-radius: 8px;
            font-size: 14px;
            transition: all 0.3s ease;
            background: #f8f9fa;
            font-weight: 500;
            height: 45px;
        }
        
        .form-control:focus {
            border-color: #d9534f;
            background: white;
            box-shadow: 0 0 0 2px rgba(217, 83, 79, 0.1);
            outline: none;
        }
        
        .input-icon {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: #d9534f;
            font-size: 16px;
            z-index: 2;
        }
        
        .btn-login {
            background: linear-gradient(135deg, #d9534f, #c9302c);
            color: white;
            border: none;
            padding: 14px 15px;
            width: 100%;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 3px 8px rgba(217, 83, 79, 0.3);
            letter-spacing: 0.8px;
            text-transform: uppercase;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            margin-top: 10px;
            height: 45px;
        }
        
        .btn-login:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(217, 83, 79, 0.4);
        }
        
        .alert {
            padding: 10px 12px;
            margin-bottom: 15px;
            border-radius: 6px;
            font-weight: 500;
            border-left: 3px solid;
            font-size: 13px;
        }
        
        .alert-success {
            background-color: #f0f9f4;
            color: #0f5132;
            border-left-color: #0f5132;
        }
        
        .alert-error {
            background-color: #fdf2f2;
            color: #842029;
            border-left-color: #842029;
        }
        
        .footer {
            margin-top: 15px;
            text-align: center;
            padding-top: 15px;
            border-top: 1px solid #e1e5e9;
        }
        
        .footer p {
            font-size: 11px;
            color: #888;
            font-weight: 500;
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .login-container {
                flex-direction: column;
                max-height: 90vh;
            }
            
            .image-section {
                padding: 20px;
                min-height: 200px;
            }
            
            .brand-logo {
                width: 60px;
                height: 60px;
                font-size: 24px;
            }
            
            .brand-name {
                font-size: 22px;
            }
            
            .brand-subtitle {
                font-size: 14px;
            }
            
            .form-section {
                padding: 30px;
            }
        }
        
        @media (max-width: 480px) {
            .login-container {
                width: 95%;
            }
            
            .form-section {
                padding: 20px;
            }
            
            .brand-name {
                font-size: 20px;
            }
        }
        
        /* Loading animation for button */
        .btn-loading {
            pointer-events: none;
            opacity: 0.8;
        }
        
        .btn-loading .btn-text {
            display: none;
        }
        
        .btn-loading::after {
            content: 'Signing in...';
            font-size: 13px;
        }
        
        .btn-loading i {
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Ensure no scrollbars appear */
        ::-webkit-scrollbar {
            display: none;
        }
        
        * {
            scrollbar-width: none;
        }
    </style>
</head>
<body>
    <div class="login-wrapper">
        <div class="login-container">
            <!-- Image Section -->
            <div class="image-section">
                <div class="image-content">
                    <div class="brand-logo">
                        <i class="fas fa-cash-register"></i>
                    </div>
                    <h1 class="brand-name">MUWAKA ENTERPRISE</h1>
                    <p class="brand-subtitle">Point of Sale System</p>
                    
                    <ul class="feature-list">
                        <li><i class="fas fa-barcode"></i> Barcode Scanning</li>
                        <li><i class="fas fa-chart-bar"></i> Sales Analytics</li>
                        <li><i class="fas fa-boxes"></i> Inventory Management</li>
                        <li><i class="fas fa-receipt"></i> Invoice Generation</li>
                        <li><i class="fas fa-users"></i> Customer Management</li>
                    </ul>
                </div>
            </div>
            
            <!-- Form Section -->
            <div class="form-section">
                <h2>Login to Your Account</h2>
                
                <?php echo display_msg($msg); ?>
                
                <form method="post" action="auth.php" class="clearfix" id="loginForm">
                    <div class="form-group">
                        <label for="username">
                            Username
                        </label>
                        <div class="input-with-icon">
                            <i class="fas fa-user input-icon"></i>
                            <input type="text" class="form-control" name="username" placeholder="Enter your username" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="password">
                            Password
                        </label>
                        <div class="input-with-icon">
                            <i class="fas fa-lock input-icon"></i>
                            <input type="password" class="form-control" name="password" placeholder="Enter your password" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn-login" id="loginButton">
                            <i class="fas fa-sign-in-alt"></i>
                            <span class="btn-text">Login</span>
                        </button>
                    </div>
                </form>
                
                <div class="footer">
                    <p>&copy; <?php echo date('Y'); ?> MUWAKA ENTERPRISE. All rights reserved.</p>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Add loading state to login button
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const button = document.getElementById('loginButton');
            button.classList.add('btn-loading');
        });
        
        // Prevent any scrolling
        document.addEventListener('wheel', function(e) {
            if (!e.ctrlKey) {
                e.preventDefault();
            }
        }, { passive: false });
        
        document.addEventListener('touchmove', function(e) {
            e.preventDefault();
        }, { passive: false });
        
        document.addEventListener('keydown', function(e) {
            // Prevent spacebar and arrow keys from scrolling
            if ([32, 33, 34, 35, 36, 37, 38, 39, 40].includes(e.keyCode)) {
                if (e.target.tagName !== 'INPUT' && e.target.tagName !== 'TEXTAREA') {
                    e.preventDefault();
                }
            }
        });
        
        // Add focus effects to form inputs
        const inputs = document.querySelectorAll('.form-control');
        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.classList.add('focused');
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.classList.remove('focused');
            });
        });
    </script>
</body>
</html>
<?php include_once('layouts/footer.php'); ?>