<?php
$page_title = 'Daily Sales';
require_once('includes/load.php');
page_require_level(3);

// Ensure session started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Reset cart at midnight
if (!isset($_SESSION['last_reset'])) {
    $_SESSION['last_reset'] = date("Y-m-d"); // set today's date
}
if ($_SESSION['last_reset'] !== date("Y-m-d")) {
    $_SESSION['cart'] = [];   // empty cart
    $_SESSION['last_reset'] = date("Y-m-d"); // update reset date
}

// Get today's date
$today = date('Y-m-d');

// Fetch today's sales data
global $db;
$sql  = "SELECT s.qty, 
                s.qty AS total_sales, 
                s.date, 
                p.name, 
                (p.sale_price * s.qty) AS total_saleing_price
         FROM sales s
         LEFT JOIN products p ON s.product_id = p.id
         WHERE DATE(s.date) = '{$today}'
         ORDER BY s.date DESC";

$result = $db->query($sql);

$sales = [];
$total_quantity = 0;
$total_amount = 0;

if ($result && $db->num_rows($result) > 0) {
    while ($row = $db->fetch_assoc($result)) {
        $sales[] = $row;
        $total_quantity += (int)$row['total_sales'];
        $total_amount += (float)$row['total_saleing_price'];
    }
}
?>

<?php include_once('layouts/header.php'); ?>

<style>
@media print {
    body * {
        visibility: hidden;
    }
    .print-section, .print-section * {
        visibility: visible;
    }
    .print-section {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
    }
    .no-print {
        display: none !important;
    }
    .table {
        border-collapse: collapse;
        width: 100%;
    }
    .table th, .table td {
        border: 1px solid #ddd;
        padding: 8px;
    }
    .table th {
        background-color: #f2f2f2;
        color: #000;
    }
    .page-break {
        page-break-after: always;
    }
}
</style>

<div class="row">
  <div class="col-md-12">
    <?php echo display_msg($msg); ?>
  </div>
</div>

<div class="row">
  <div class="col-md-12">
    <div class="panel panel-default print-section">
      <div class="panel-heading clearfix">
        <strong>
          <span class="glyphicon glyphicon-stats"></span>
          <span> Daily Sales Report (<?php echo date("F j, Y"); ?>)</span>
        </strong>
        <div class="pull-right no-print">
          <button onclick="window.print()" class="btn btn-primary btn-xs">
            <span class="glyphicon glyphicon-print"></span> Print Report
          </button>
          <a href="daily_sales.php" class="btn btn-default btn-xs">
            <span class="glyphicon glyphicon-refresh"></span> Refresh
          </a>
        </div>
      </div>
      <div class="panel-body">
        <!-- Printable Header -->
        <div class="print-header text-center" style="margin-bottom: 20px; display: none;">
          <h2>MUWAKA ENTERPRISE</h2>
          <h3>Daily Sales Report</h3>
          <p><?php echo date("F j, Y"); ?></p>
          <p>Generated on: <?php echo date("Y-m-d H:i:s"); ?></p>
        </div>
        
        <?php if (!empty($sales)): ?>
        <div class="well well-sm" style="background: #f5f5f5; padding: 10px; margin-bottom: 15px;">
          <div class="row">
            <div class="col-md-4">
              <strong>Total Sales:</strong> <?php echo $total_quantity; ?> items
            </div>
            <div class="col-md-4">
              <strong>Total Revenue:</strong> Ksh <?php echo number_format($total_amount, 2); ?>
            </div>
            <div class="col-md-4">
              <strong>Transactions:</strong> <?php echo count($sales); ?>
            </div>
          </div>
        </div>
        <?php endif; ?>
        
        <table class="table table-bordered table-hover table-striped">
          <thead style="background:#2c3e50; color:white;">
            <tr>
              <th class="text-center" style="width: 50px;">#</th>
              <th>Product Name</th>
              <th class="text-center" style="width: 15%;">Quantity Sold</th>
              <th class="text-center" style="width: 15%;">Unit Price (Ksh)</th>
              <th class="text-center" style="width: 15%;">Total (Ksh)</th>
              <th class="text-center" style="width: 20%;">Time</th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($sales)): ?>
              <?php $count = 1; ?>
              <?php foreach ($sales as $sale): ?>
              <tr>
                <td class="text-center"><?php echo $count++; ?></td>
                <td><?php echo remove_junk($sale['name']); ?></td>
                <td class="text-center"><?php echo (int)$sale['total_sales']; ?></td>
                <td class="text-center"><?php echo number_format($sale['total_saleing_price']/$sale['total_sales'], 2); ?></td>
                <td class="text-center text-success">
                  <?php echo number_format($sale['total_saleing_price'], 2); ?>
                </td>
                <td class="text-center">
                  <?php
                    // make sure timezone is set
                    date_default_timezone_set('Africa/Nairobi'); 
                    echo date("h:i A", strtotime($sale['date']));
                  ?>
                </td>
              </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr>
                <td colspan="6" class="text-center text-danger">No sales found for today.</td>
              </tr>
            <?php endif; ?>
          </tbody>
          <?php if (!empty($sales)): ?>
          <tfoot style="font-weight:bold; background:#ecf0f1;">
            <tr>
              <td class="text-center" colspan="2">TOTAL</td>
              <td class="text-center"><?php echo $total_quantity; ?></td>
              <td class="text-center">-</td>
              <td class="text-center text-primary"><?php echo number_format($total_amount, 2); ?></td>
              <td class="text-center">-</td>
            </tr>
          </tfoot>
          <?php endif; ?>
        </table>
        
        <!-- Signature Section for Printing -->
        <div class="row no-print" style="margin-top: 30px;">
          <div class="col-md-12">
            <div class="well" style="background: #f9f9f9; padding: 15px;">
              <h4>Report Summary</h4>
              <p>This report shows all sales transactions for <?php echo date("F j, Y"); ?>.</p>
              <p>Report generated by: <?php echo $_SESSION['username'] ?? 'System'; ?></p>
            </div>
          </div>
        </div>
        
        <div class="print-only" style="display: none; margin-top: 50px;">
          <div style="float: left; width: 45%;">
            <p>_________________________</p>
            <p>Cashier's Signature</p>
          </div>
          <div style="float: right; width: 45%; text-align: right;">
            <p>_________________________</p>
            <p>Manager's Signature</p>
          </div>
          <div style="clear: both;"></div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
// Function to handle printing
function preparePrint() {
    // Show printable elements
    document.querySelectorAll('.print-header, .print-only').forEach(function(el) {
        el.style.display = 'block';
    });
    
    // Hide non-printable elements
    document.querySelectorAll('.no-print').forEach(function(el) {
        el.style.display = 'none';
    });
    
    // Wait a moment before printing to allow DOM to update
    setTimeout(function() {
        window.print();
        
        // Revert changes after printing
        setTimeout(function() {
            document.querySelectorAll('.print-header, .print-only').forEach(function(el) {
                el.style.display = 'none';
            });
            document.querySelectorAll('.no-print').forEach(function(el) {
                el.style.display = '';
            });
        }, 500);
    }, 100);
}

// Attach event to print button
document.querySelector('button[onclick]').addEventListener('click', function(e) {
    e.preventDefault();
    preparePrint();
});
</script>

<?php include_once('layouts/footer.php'); ?>