<?php
  $page_title = 'Manage Categories';
  require_once('includes/load.php');
  // Checkin What level user has permission to view this page
  page_require_level(1);

  // Handle adding new category
  if (isset($_POST['add_cat'])) {
      $req_fields = array('categorie-name');
      validate_fields($req_fields);

      if (empty($errors)) {
          $name = remove_junk($db->escape($_POST['categorie-name']));
          $sql  = "INSERT INTO categories (name) VALUES ('{$name}')";
          if ($db->query($sql)) {
              $session->msg("s", "Category added successfully.");
              redirect('categorie.php', false);
          } else {
              $session->msg("d", "Failed to add category.");
              redirect('categorie.php', false);
          }
      } else {
          $session->msg("d", $errors);
          redirect('categorie.php', false);
      }
  }

  // Fetch all categories
  $all_categories = find_all('categories');
?>

<?php include_once('layouts/header.php'); ?>

<div class="row">
  <div class="col-md-12">
    <?php echo display_msg($msg); ?>
  </div>
</div>

<div class="row">
  <!-- Add new category -->
  <div class="col-md-5">
    <div class="panel panel-default">
      <div class="panel-heading">
        <strong>
          <span class="glyphicon glyphicon-th"></span>
          <span>Add New Category</span>
        </strong>
      </div>
      <div class="panel-body">
        <form method="post" action="categorie.php">
          <div class="form-group">
            <input type="text" class="form-control" name="categorie-name" placeholder="Category Name">
          </div>
          <button type="submit" name="add_cat" class="btn btn-primary">Add Category</button>
        </form>
      </div>
    </div>
  </div>

  <!-- All categories -->
  <div class="col-md-7">
    <div class="panel panel-default">
      <div class="panel-heading">
        <strong>
          <span class="glyphicon glyphicon-th"></span>
          <span>All Categories</span>
        </strong>
      </div>
      <div class="panel-body">
        <table class="table table-bordered table-striped table-hover">
          <thead>
            <tr>
              <th class="text-center" style="width: 50px;">#</th>
              <th>Category Name</th>
              <th class="text-center" style="width: 100px;">Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($all_categories as $cat): ?>
              <tr>
                <td class="text-center"><?php echo count_id(); ?></td>
                <td><?php echo remove_junk(ucfirst($cat['name'])); ?></td>
                <td class="text-center">
                  <div class="btn-group">
                    <a href="edit_categorie.php?id=<?php echo (int)$cat['id']; ?>" class="btn btn-xs btn-warning" data-toggle="tooltip" title="Edit">
                      <span class="glyphicon glyphicon-edit"></span>
                    </a>
                    <a href="delete_categorie.php?id=<?php echo (int)$cat['id']; ?>" class="btn btn-xs btn-danger" data-toggle="tooltip" title="Remove" onclick="return confirm('Are you sure you want to delete this category?');">
                      <span class="glyphicon glyphicon-trash"></span>
                    </a>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?php include_once('layouts/footer.php'); ?>
