<?php
$page_title = 'Add Sale';
require_once('includes/load.php');
// Check user permission
page_require_level(3);

if (isset($_POST['add_sale'])) {
    $req_fields = array('product_id','quantity','price');
    validate_fields($req_fields);

    if (empty($errors)) {
        $p_id     = (int)$_POST['product_id'];
        $s_qty    = (int)$_POST['quantity'];
        $s_price  = (float)$_POST['price'];

        // ✅ Save exact transaction timestamp in Nairobi timezone
        date_default_timezone_set('Africa/Nairobi');
        $now = date('Y-m-d H:i:s');

        $sql  = "INSERT INTO sales (product_id, qty, price, date) VALUES (";
        $sql .= " '{$p_id}', '{$s_qty}', '{$s_price}', '{$now}'";
        $sql .= ")";

        if ($db->query($sql)) {
            $session->msg('s',"Sale added successfully. Time saved: {$now}");
            redirect('add_sale.php', false);
        } else {
            $session->msg('d',' Sorry failed to add sale.');
            redirect('add_sale.php', false);
        }
    } else {
        $session->msg("d", $errors);
        redirect('add_sale.php',false);
    }
}
?>

<?php include_once('layouts/header.php'); ?>
<div class="row">
  <div class="col-md-12">
    <?php echo display_msg($msg); ?>
  </div>
</div>
<div class="row">
  <div class="col-md-6">
    <div class="panel panel-default">
      <div class="panel-heading">
        <strong><span class="glyphicon glyphicon-th"></span> Add New Sale</strong>
      </div>
      <div class="panel-body">
        <form method="post" action="add_sale.php">
          <div class="form-group">
            <label for="product_id">Product ID</label>
            <input type="number" class="form-control" name="product_id" required>
          </div>
          <div class="form-group">
            <label for="quantity">Quantity</label>
            <input type="number" class="form-control" name="quantity" required>
          </div>
          <div class="form-group">
            <label for="price">Total Price</label>
            <input type="text" class="form-control" name="price" required>
          </div>
          <button type="submit" name="add_sale" class="btn btn-primary">Save</button>
        </form>
      </div>
    </div>
  </div>
</div>
<?php include_once('layouts/footer.php'); ?>
