<?php
require_once('includes/load.php');
page_require_level(2);

$output = '';
$query = isset($_POST['query']) ? $db->escape($_POST['query']) : '';

// ✅ If search text exists, filter results
if($query != ''){
  $sql  = "SELECT p.id,p.name,p.quantity,p.buy_price,p.sale_price,p.categorie_id,p.media_id,p.date,p.barcode,";
  $sql .= "c.name AS categorie,m.file_name AS image ";
  $sql .= "FROM products p ";
  $sql .= "LEFT JOIN categories c ON c.id = p.categorie_id ";
  $sql .= "LEFT JOIN media m ON m.id = p.media_id ";
  $sql .= "WHERE p.name LIKE '%{$query}%' OR p.barcode LIKE '%{$query}%'";
  $products = find_by_sql($sql);
} else {
  // ✅ Otherwise show all products
  $products = join_product_table();
}

if($products){
  foreach($products as $product){
    $output .= '<tr>';
    $output .= '<td class="text-center">'.count_id().'</td>';
    $output .= '<td>';
    if($product['media_id'] === '0'){
      $output .= '<img class="img-avatar img-circle" src="uploads/products/no_image.png" alt="">';
    } else {
      $output .= '<img class="img-avatar img-circle" src="uploads/products/'.$product['image'].'" alt="">';
    }
    $output .= '</td>';
    $output .= '<td>'.remove_junk($product['barcode']).'</td>';
    $output .= '<td>'.remove_junk($product['name']).'</td>';
    $output .= '<td class="text-center">'.remove_junk($product['categorie']).'</td>';
    $output .= '<td class="text-center">'.remove_junk($product['quantity']).'</td>';
    $output .= '<td class="text-center">'.remove_junk($product['buy_price']).'</td>';
    $output .= '<td class="text-center">'.remove_junk($product['sale_price']).'</td>';
    $output .= '<td class="text-center">'.read_date($product['date']).'</td>';
    $output .= '<td class="text-center">
                  <div class="btn-group">
                    <a href="edit_product.php?id='.(int)$product['id'].'" class="btn btn-info btn-xs" title="Edit">
                      <span class="glyphicon glyphicon-edit"></span>
                    </a>
                    <a href="delete_product.php?id='.(int)$product['id'].'" class="btn btn-danger btn-xs" title="Delete">
                      <span class="glyphicon glyphicon-trash"></span>
                    </a>
                  </div>
                </td>';
    $output .= '</tr>';
  }
} else {
  $output .= '<tr><td colspan="10" class="text-center">No products found</td></tr>';
}

echo $output;
?>
