<?php
  $page_title = 'Admin Home Page';
  require_once('includes/load.php');
  // Checkin What level user has permission to view this page
   page_require_level(1);
?>
<?php
 $c_categorie     = count_by_id('categories');
 $c_product       = count_by_id('products');
 $c_sale          = count_by_id('sales');
 $c_user          = count_by_id('users');
 $products_sold   = find_higest_saleing_product('10');
 $recent_products = find_recent_product_added('5');
 $recent_sales    = find_recent_sale_added('5');
 
 // Get daily sales total
 $today = date('Y-m-d');
 $daily_sales = find_daily_sales_total($today);
?>
<?php include_once('layouts/header.php'); ?>

<div class="row">
   <div class="col-md-12">
     <?php echo display_msg($msg); ?>
   </div>
</div>

<div class="dashboard-container">
  <!-- Stats Cards -->
  <div class="stats-grid">
    <a href="users.php" class="stat-card user-card">
      <div class="stat-icon">
        <i class="fas fa-users"></i>
      </div>
      <div class="stat-content">
        <h3><?php echo $c_user['total']; ?></h3>
        <p>Users</p>
      </div>
    </a>
    
    <a href="sales.php?filter=today" class="stat-card sales-card">
      <div class="stat-icon">
        <i class="fas fa-calendar-day"></i>
      </div>
      <div class="stat-content">
        <h3>$<?php echo number_format($daily_sales['total_sales'] ?? 0, 2); ?></h3>
        <p>Daily Sales</p>
        <small><?php echo date('M j, Y'); ?></small>
      </div>
    </a>

    <a href="categorie.php" class="stat-card category-card">
      <div class="stat-icon">
        <i class="fas fa-tags"></i>
      </div>
      <div class="stat-content">
        <h3><?php echo $c_categorie['total']; ?></h3>
        <p>Categories</p>
      </div>
    </a>

    <a href="product.php" class="stat-card product-card">
      <div class="stat-icon">
        <i class="fas fa-box"></i>
      </div>
      <div class="stat-content">
        <h3><?php echo $c_product['total']; ?></h3>
        <p>Products</p>
      </div>
    </a>

    <a href="sales.php" class="stat-card revenue-card">
      <div class="stat-icon">
        <i class="fas fa-shopping-cart"></i>
      </div>
      <div class="stat-content">
        <h3><?php echo $c_sale['total']; ?></h3>
        <p>Total Sales</p>
      </div>
    </a>
  </div>

  <!-- Dashboard Content -->
  <div class="dashboard-content">
    <!-- Top Selling Products -->
    <div class="dashboard-card">
      <div class="card-header">
        <h3><i class="fas fa-chart-line"></i> Top Selling Products</h3>
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="dashboard-table">
            <thead>
              <tr>
                <th>Product</th>
                <th>Sold</th>
                <th>Quantity</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($products_sold as $product_sold): ?>
              <tr>
                <td><?php echo remove_junk(first_character($product_sold['name'])); ?></td>
                <td class="text-center"><?php echo (int)$product_sold['totalSold']; ?></td>
                <td class="text-center"><?php echo (int)$product_sold['totalQty']; ?></td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <!-- Recent Sales -->
    <div class="dashboard-card">
      <div class="card-header">
        <h3><i class="fas fa-receipt"></i> Recent Sales</h3>
        <a href="sales.php?filter=today" class="view-all">Today's Sales</a>
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="dashboard-table">
            <thead>
              <tr>
                <th>Product</th>
                <th>Date</th>
                <th>Amount</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($recent_sales as $recent_sale): ?>
              <tr>
                <td>
                  <a href="edit_sale.php?id=<?php echo (int)$recent_sale['id']; ?>">
                    <?php echo remove_junk(first_character($recent_sale['name'])); ?>
                  </a>
                </td>
                <td><?php echo remove_junk(ucfirst($recent_sale['date'])); ?></td>
                <td>$<?php echo remove_junk(first_character($recent_sale['price'])); ?></td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <!-- Recent Products -->
    <div class="dashboard-card">
      <div class="card-header">
        <h3><i class="fas fa-cube"></i> Recently Added Products</h3>
      </div>
      <div class="card-body">
        <div class="recent-products">
          <?php foreach ($recent_products as $recent_product): ?>
          <div class="product-item">
            <div class="product-image">
              <?php if($recent_product['media_id'] === '0'): ?>
                <img src="uploads/products/no_image.png" alt="No Image">
              <?php else: ?>
                <img src="uploads/products/<?php echo $recent_product['image'];?>" alt="<?php echo remove_junk(first_character($recent_product['name'])); ?>">
              <?php endif;?>
            </div>
            <div class="product-details">
              <h4>
                <a href="edit_product.php?id=<?php echo (int)$recent_product['id'];?>">
                  <?php echo remove_junk(first_character($recent_product['name']));?>
                </a>
              </h4>
              <p><?php echo remove_junk(first_character($recent_product['categorie'])); ?></p>
            </div>
            <div class="product-price">
              $<?php echo (int)$recent_product['sale_price']; ?>
            </div>
          </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
/* Dashboard Layout */
.dashboard-container {
  padding: 20px;
}

/* Stats Grid */
.stats-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
  gap: 20px;
  margin-bottom: 30px;
}

.stat-card {
  background: white;
  border-radius: 12px;
  padding: 25px;
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
  display: flex;
  align-items: center;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
  text-decoration: none;
  color: #333;
  position: relative;
}

.stat-card:hover {
  transform: translateY(-5px);
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
  text-decoration: none;
  color: #333;
}

.stat-icon {
  width: 60px;
  height: 60px;
  border-radius: 12px;
  display: flex;
  align-items: center;
  justify-content: center;
  margin-right: 20px;
  font-size: 24px;
  color: white;
}

.user-card .stat-icon { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
.sales-card .stat-icon { background: linear-gradient(135deg, #ffd700 0%, #ffa500 100%); }
.category-card .stat-icon { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); }
.product-card .stat-icon { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); }
.revenue-card .stat-icon { background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%); }

.stat-content h3 {
  font-size: 32px;
  margin: 0;
  font-weight: 700;
  color: #2d3748;
}

.stat-content p {
  margin: 5px 0 0;
  color: #718096;
  font-size: 16px;
  font-weight: 500;
}

.stat-content small {
  color: #a0aec0;
  font-size: 12px;
  margin-top: 5px;
  display: block;
}

/* Dashboard Content */
.dashboard-content {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
  gap: 25px;
}

.dashboard-card {
  background: white;
  border-radius: 12px;
  overflow: hidden;
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
}

.card-header {
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  color: white;
  padding: 20px;
  display: flex;
  justify-content: between;
  align-items: center;
}

.card-header h3 {
  margin: 0;
  font-size: 18px;
  font-weight: 600;
  display: flex;
  align-items: center;
  flex-grow: 1;
}

.card-header h3 i {
  margin-right: 10px;
}

.view-all {
  color: white;
  text-decoration: none;
  font-size: 14px;
  padding: 5px 10px;
  border: 1px solid white;
  border-radius: 5px;
  transition: all 0.3s ease;
}

.view-all:hover {
  background: white;
  color: #667eea;
  text-decoration: none;
}

.card-body {
  padding: 20px;
}

/* Tables */
.dashboard-table {
  width: 100%;
  border-collapse: collapse;
}

.dashboard-table th {
  text-align: left;
  padding: 12px 15px;
  background-color: #f8f9fa;
  font-weight: 600;
  color: #2d3748;
  border-bottom: 2px solid #e2e8f0;
}

.dashboard-table td {
  padding: 12px 15px;
  border-bottom: 1px solid #e2e8f0;
  color: #4a5568;
}

.dashboard-table tr:hover {
  background-color: #f7fafc;
}

.dashboard-table a {
  color: #4299e1;
  text-decoration: none;
  font-weight: 500;
}

.dashboard-table a:hover {
  text-decoration: underline;
}

/* Recent Products */
.recent-products {
  display: flex;
  flex-direction: column;
  gap: 15px;
}

.product-item {
  display: flex;
  align-items: center;
  padding: 15px;
  background: #f8fafc;
  border-radius: 8px;
  transition: background-color 0.2s ease;
}

.product-item:hover {
  background: #edf2f7;
}

.product-image {
  width: 50px;
  height: 50px;
  border-radius: 8px;
  overflow: hidden;
  margin-right: 15px;
  flex-shrink: 0;
}

.product-image img {
  width: 100%;
  height: 100%;
  object-fit: cover;
}

.product-details {
  flex-grow: 1;
}

.product-details h4 {
  margin: 0 0 5px;
  font-size: 16px;
}

.product-details h4 a {
  color: #2d3748;
  text-decoration: none;
}

.product-details h4 a:hover {
  color: #667eea;
  text-decoration: none;
}

.product-details p {
  margin: 0;
  color: #718096;
  font-size: 14px;
}

.product-price {
  font-weight: 700;
  color: #48bb78;
  font-size: 16px;
  flex-shrink: 0;
}

/* Responsive */
@media (max-width: 1200px) {
  .dashboard-content {
    grid-template-columns: 1fr;
  }
}

@media (max-width: 768px) {
  .stats-grid {
    grid-template-columns: 1fr;
  }
  
  .stat-card {
    padding: 20px;
  }
  
  .stat-icon {
    width: 50px;
    height: 50px;
    font-size: 20px;
    margin-right: 15px;
  }
  
  .stat-content h3 {
    font-size: 28px;
  }
  
  .card-header {
    flex-direction: column;
    align-items: flex-start;
    gap: 10px;
  }
  
  .view-all {
    align-self: flex-end;
  }
}

@media (max-width: 480px) {
  .dashboard-container {
    padding: 15px;
  }
  
  .stat-card {
    flex-direction: column;
    text-align: center;
  }
  
  .stat-icon {
    margin-right: 0;
    margin-bottom: 15px;
  }
}
</style>

<!-- Font Awesome for icons -->
<script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>

<?php include_once('layouts/footer.php'); ?>