<?php
require_once('includes/load.php');

// DB config
$host = "localhost";
$user = "fzknsxuj_collijoh";
$pass = "MU496700?";
$dbname = "fzknsxuj_collijoh_db";

$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Initialize cart if not set
if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

// Generate Transaction ID for session
$transactionId = $_SESSION['txn_id'] ?? null;

if (!isset($_SESSION['txn_id'])) {
    $_SESSION['txn_id'] = uniqid("TXN");
}

/* ================================
   AJAX: Handle barcode scan
   ================================ */
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['barcode']) && isset($_POST['ajax'])) {
    // Clean the barcode input
    $barcode = trim($_POST['barcode']);
    $barcode = $conn->real_escape_string($barcode);
    
    // Remove any non-numeric characters if needed (some scanners add prefixes)
    $cleanBarcode = preg_replace('/[^0-9]/', '', $barcode);
    
    // Try both the original and cleaned barcode
    $sql = "SELECT id, barcode, name, sale_price FROM products 
            WHERE barcode = '$barcode' OR barcode = '$cleanBarcode' 
            LIMIT 1";
    
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        $product = $result->fetch_assoc();
        echo json_encode(["success" => true] + $product);
    } else {
        // Log the failed barcode for debugging
        error_log("Barcode not found: " . $barcode);
        echo json_encode(["success" => false, "searched_barcode" => $barcode]);
    }
    exit;
}

/* ================================
   AJAX: Search product by name
   ================================ */
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['search_name']) && isset($_POST['ajax'])) {
    $term = $conn->real_escape_string(trim($_POST['search_name']));
    $sql = "SELECT id, barcode, name, sale_price 
            FROM products 
            WHERE name LIKE '%$term%' 
            ORDER BY name ASC 
            LIMIT 10";
    $result = $conn->query($sql);

    $products = [];
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $products[] = $row;
        }
    }
    echo json_encode($products);
    exit;
}

/* ================================
   AJAX: Update session cart
   ================================ */
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['update_cart'])) {
    $id = intval($_POST['product_id']);
    $name = $conn->real_escape_string($_POST['product_name']);
    $price = floatval($_POST['product_price']);

    $found = false;
    foreach ($_SESSION['cart'] as &$item) {
        if ($item['id'] == $id) {
            $item['qty'] += 1;
            $found = true;
            break;
        }
    }
    if (!$found) {
        $_SESSION['cart'][] = [
            'id' => $id,
            'name' => $name,
            'price' => $price,
            'qty' => 1
        ];
    }
    exit;
}

/* ================================
   Handle delete item
   ================================ */
if (isset($_GET['delete'])) {
    $deleteId = intval($_GET['delete']);
    foreach ($_SESSION['cart'] as $key => $item) {
        if ($item['id'] == $deleteId) {
            unset($_SESSION['cart'][$key]);
            break;
        }
    }
    $_SESSION['cart'] = array_values($_SESSION['cart']);
    header("Location: Cashier.php");
    exit;
}

/* ================================
   Handle complete transaction
   ================================ */
if (isset($_POST['complete_transaction'])) {
    $paymentMode = $conn->real_escape_string($_POST['payment_mode'] ?? 'cash');
    $cashReceived = floatval($_POST['cash_received'] ?? 0);

    // Update quantities from cashier input
    if (isset($_POST['quantities'])) {
        foreach ($_POST['quantities'] as $productId => $qty) {
            foreach ($_SESSION['cart'] as &$item) {
                if ($item['id'] == $productId) {
                    $item['qty'] = max(1, intval($qty));
                    break;
                }
            }
        }
    }

    if (!empty($_SESSION['cart'])) {
        $transactionId = $_SESSION['txn_id'];
        $totalAmount = 0;

        // Calculate total amount first
        foreach ($_SESSION['cart'] as $item) {
            $totalAmount += $item['price'] * $item['qty'];
        }

        // Calculate balance
        $balance = $cashReceived - $totalAmount;

        // Save sales and update stock
        foreach ($_SESSION['cart'] as $item) {
            $productId = $item['id'];
            $qty = $item['qty'];
            $price = $item['price'];
            $total = $price * $qty;

            // Fixed INSERT statement - using correct variables
            $conn->query("INSERT INTO sales 
                (transaction_id, product_id, qty, price, total, payment_mode, cash_received, balance) 
                VALUES 
                ('$transactionId', '$productId', '$qty', '$price', '$total', '$paymentMode', '$cashReceived', '$balance')");

            $conn->query("UPDATE products SET quantity = quantity - $qty WHERE id = $productId");
        }

        // Store cart data for potential restoration if user cancels
        $savedCart = $_SESSION['cart'];
        $savedTxnId = $_SESSION['txn_id'];
        
        // Clear cart only if user confirms
        $_SESSION['pending_clear'] = true;
        $_SESSION['saved_cart'] = $savedCart;
        $_SESSION['saved_txn_id'] = $savedTxnId;

        // Success popup code - CORRECTED VERSION
        echo "
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Create overlay
    const overlay = document.createElement('div');
    overlay.style.cssText = 'position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.7); backdrop-filter: blur(5px); z-index: 9998; display: flex; align-items: center; justify-content: center;';
    
    // Create popup
    const popup = document.createElement('div');
    popup.innerHTML = '<div style=\"background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 0; border-radius: 20px; box-shadow: 0 20px 40px rgba(0,0,0,0.3); z-index: 9999; text-align: center; font-family: Segoe UI, Tahoma, Geneva, Verdana, sans-serif; min-width: 400px; max-width: 90vw; overflow: hidden; color: white;\"><div style=\"background: rgba(255,255,255,0.1); padding: 25px; border-bottom: 1px solid rgba(255,255,255,0.2);\"><div style=\"background: #27ae60; width: 80px; height: 80px; border-radius: 50%; margin: 0 auto 15px; display: flex; align-items: center; justify-content: center; font-size: 40px;\"><i class=\"fas fa-check-circle\"></i></div><h3 style=\"margin: 0; font-size: 28px; font-weight: 600; color: white;\">Transaction Successful</h3><p style=\"margin: 10px 0 0; opacity: 0.9; font-size: 16px;\">Transaction ID: ' + '$transactionId' + '</p></div><div style=\"padding: 30px; background: rgba(255,255,255,0.05);\"><div style=\"display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 25px;\"><div style=\"background: rgba(255,255,255,0.15); padding: 20px; border-radius: 10px; border: 2px solid rgba(255,255,255,0.3);\"><div style=\"font-size: 14px; opacity: 0.9; margin-bottom: 8px; color: #e4dcceff; font-weight: 600;\">Total Amount</div><div style=\"font-size: 24px; font-weight: 700; color: #dfd7c2ff; text-shadow: 0 2px 4px rgba(17, 214, 17, 0.3);\">KSH ' + '" . number_format($totalAmount, 2) . "' + '</div></div><div style=\"background: rgba(255,255,255,0.15); padding: 20px; border-radius: 10px; border: 2px solid rgba(255,255,255,0.3);\"><div style=\"font-size: 14px; opacity: 0.9; margin-bottom: 8px; color: #250350ff; font-weight: 600;\">Cash Received</div><div style=\"font-size: 24px; font-weight: 700; color: #2f0361ff; text-shadow: 0 2px 4px rgba(0,0,0,0.3);\">KSH ' + '" . number_format($cashReceived, 2) . "' + '</div></div></div><div style=\"background: " . ($balance >= 0 ? 'rgba(39, 174, 96, 0.3)' : 'rgba(231, 76, 60, 0.3)') . "; padding: 20px; border-radius: 10px; border: 3px solid " . ($balance >= 0 ? 'rgba(39, 174, 96, 0.5)' : 'rgba(231, 76, 60, 0.5)') . "; margin-bottom: 25px; box-shadow: 0 4px 15px " . ($balance >= 0 ? 'rgba(39, 174, 96, 0.3)' : 'rgba(231, 76, 60, 0.3)') . ";\"><div style=\"font-size: 16px; opacity: 1.9; margin-bottom: 10px; color: #830768ff; font-weight: 600;\">Balance</div><div style=\"font-size: 32px; font-weight: 800; color: #830768ff; text-shadow: 0 2px 8px " . ($balance >= 0 ? 'rgba(39, 174, 96, 0.5)' : 'rgba(231, 76, 60, 0.5)') . ";\">KSH ' + '" . number_format($balance, 2) . "' + '</div></div><div style=\"display: flex; gap: 15px; justify-content: center;\"><button id=\"cancelButton\" style=\"padding: 12px 25px; border: 2px solid rgba(255,255,255,0.4); border-radius: 8px; background: rgba(231, 76, 60, 0.8); color: white; font-size: 14px; font-weight: 600; cursor: pointer; transition: all 0.3s; display: flex; align-items: center; gap: 8px;\"><i class=\"fas fa-times\"></i>Cancel (Keep Items)</button><button id=\"closePopup\" style=\"padding: 12px 30px; border: none; border-radius: 8px; background: #27ae60; color: white; font-size: 14px; font-weight: 600; cursor: pointer; transition: all 0.3s; display: flex; align-items: center; gap: 8px; box-shadow: 0 4px 15px rgba(39, 174, 96, 0.4);\"><i class=\"fas fa-check\"></i>OK (Clear Cart)</button></div><div style=\"margin-top: 15px; font-size: 12px; opacity: 0.7; color: #f39c12;\">Press Enter to clear cart and continue, or Esc to keep items</div></div><div style=\"background: rgba(0,0,0,0.3); padding: 15px; font-size: 12px; opacity: 0.8; border-top: 1px solid rgba(255,255,255,0.2); color: #f39c12;\"><i class=\"fas fa-shield-alt\"></i> Secure Transaction • MUWAKA ENTERPRISE</div></div>';
    
    // Append to body
    overlay.appendChild(popup);
    document.body.appendChild(overlay);
    document.body.style.overflow = 'hidden';

    // Focus management
    const closeBtn = document.getElementById('closePopup');
    const cancelBtn = document.getElementById('cancelButton');
    closeBtn.focus();

    // Event listeners
    closeBtn.addEventListener('click', function() {
        // Clear cart and redirect (OK button)
        fetch('Cashier.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: 'clear_cart=1'
        }).then(() => {
            window.location.href = 'Cashier.php';
        });
    });

    cancelBtn.addEventListener('click', function() {
        // Restore cart and remove popup
        fetch('Cashier.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: 'restore_cart=1'
        }).then(() => {
            overlay.remove();
            document.body.style.overflow = '';
        });
    });

    // Keyboard shortcuts
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Enter') {
            // Clear cart and redirect (Enter key)
            fetch('Cashier.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: 'clear_cart=1'
            }).then(() => {
                window.location.href = 'Cashier.php';
            });
        }
        if (e.key === 'Escape') {
            // Restore cart and remove popup (Escape key)
            fetch('Cashier.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: 'restore_cart=1'
            }).then(() => {
                overlay.remove();
                document.body.style.overflow = '';
            });
        }
    });

    // Hover effects
    const buttons = [closeBtn, cancelBtn];
    buttons.forEach(btn => {
        btn.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-2px)';
            this.style.boxShadow = '0 8px 25px rgba(0,0,0,0.3)';
            if (this.id === 'cancelButton') {
                this.style.background = 'rgba(231, 76, 60, 1)';
                this.style.borderColor = 'rgba(255,255,255,0.6)';
            } else {
                this.style.background = '#219a52';
                this.style.boxShadow = '0 8px 25px rgba(39, 174, 96, 0.6)';
            }
        });
        btn.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
            this.style.boxShadow = 'none';
            if (this.id === 'cancelButton') {
                this.style.background = 'rgba(231, 76, 60, 0.8)';
                this.style.borderColor = 'rgba(255,255,255,0.4)';
            } else {
                this.style.background = '#27ae60';
                this.style.boxShadow = '0 4px 15px rgba(39, 174, 96, 0.4)';
            }
        });
    });

    // Add animation
    popup.style.animation = 'popupSlideIn 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275)';
    
    // Add CSS animations
    const style = document.createElement('style');
    style.textContent = '@keyframes popupSlideIn {from {opacity: 0; transform: scale(0.8) translateY(-50px);} to {opacity: 1; transform: scale(1) translateY(0);}} @keyframes glow {0% {box-shadow: 0 0 5px rgba(39, 174, 96, 0.5);} 50% {box-shadow: 0 0 20px rgba(39, 174, 96, 0.8);} 100% {box-shadow: 0 0 5px rgba(39, 174, 96, 0.5);}} #closePopup {animation: glow 2s infinite;} #closePopup:hover {background: #219a52 !important; transform: translateY(-2px); animation: none;} #cancelButton:hover {background: rgba(231, 76, 60, 1) !important; transform: translateY(-2px); border-color: rgba(255,255,255,0.6) !important;}';
    document.head.appendChild(style);
});
</script>";
    }
}

/* ================================
   Handle clear cart via AJAX
   ================================ */
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['clear_cart'])) {
    $_SESSION['cart'] = [];
    unset($_SESSION['txn_id']);
    echo json_encode(['success' => true]);
    exit;
}

/* ================================
   Handle restore cart via AJAX
   ================================ */
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['restore_cart'])) {
    if (isset($_SESSION['saved_cart'])) {
        $_SESSION['cart'] = $_SESSION['saved_cart'];
        $_SESSION['txn_id'] = $_SESSION['saved_txn_id'];
        unset($_SESSION['saved_cart']);
        unset($_SESSION['saved_txn_id']);
        unset($_SESSION['pending_clear']);
    }
    echo json_encode(['success' => true]);
    exit;
}
?>

<!-- Rest of your HTML code remains the same -->


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Point of Sale System - MUWAKA ENTERPRISE</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
    :root {
        --primary: #2c3e50;
        --secondary: #3498db;
        --success: #27ae60;
        --danger: #e74c3c;
        --warning: #f39c12;
        --dark: #2c3e50;
        --light: #ecf0f1;
        --gray: #95a5a6;
    }
    
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }
    
    /* Recent Scan Table Styles */
.recent-scan-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    font-size: 14px;
}

.recent-scan-table td {
    padding: 8px 12px;
    border: 1px solid rgba(255,255,255,0.3);
    text-align: left;
}

.recent-scan-table tr:first-child td {
    background: rgba(39, 174, 96, 0.3);
    font-weight: bold;
    color: white;
}

.recent-scan-table tr:last-child td {
    background: rgba(255,255,255,0.1);
    color: var(--light);
}
    .suggestion-item {
    padding: 12px;
    border-bottom: 1px solid #eee;
    cursor: pointer;
    transition: background-color 0.2s;
}

.suggestion-item:hover,
.suggestion-item.selected {
    background-color: #f0f0f0;
}

.suggestion-item:last-child {
    border-bottom: none;
}

#suggestions {
    max-height: 250px;
    overflow-y: auto;
    border-radius: 5px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.1);
}
    
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 100vh;
        padding: 20px;
    }
    
    .page-wrapper {
        background: white;
        border-radius: 20px;
        box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        overflow: hidden;
        max-width: 1400px;
        margin: 0 auto;
    }
    
    /* Header Styles */
    header {
        background: var(--primary);
        color: white;
        padding: 20px 30px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border-bottom: 3px solid var(--secondary);
    }
    
    .cashier-info {
        display: flex;
        flex-direction: column;
        gap: 5px;
    }
    
    .cashier-name {
        font-size: 18px;
        font-weight: 600;
    }
    
    .txn-id {
        font-size: 14px;
        color: var(--light);
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    #live-time {
        background: var(--success);
        padding: 4px 12px;
        border-radius: 20px;
        font-weight: 600;
    }
    
    .brand-logo {
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .brand-logo h2 {
        color: white;
        font-size: 24px;
    }
    
    .brand-logo span {
        color: var(--warning);
    }
    
    .home-link {
        color: white;
        font-size: 24px;
        transition: transform 0.3s;
    }
    
    .home-link:hover {
        transform: scale(1.1);
        color: var(--warning);
    }
    
    /* Barcode Section */
    .barcode-section {
        background: var(--light);
        padding: 20px;
        display: grid;
        grid-template-columns: 1fr 400px;
        gap: 20px;
        border-bottom: 1px solid #ddd;
    }
    
    .scan-display {
        background: white;
        padding: 15px;
        border-radius: 10px;
        border: 2px dashed var(--gray);
        min-height: 80px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    #recent-scan-box {
        font-size: 16px;
        color: var(--dark);
        text-align: center;
    }
    
    #recent-scan-box.active {
        background: var(--success);
        color: white;
        padding: 10px;
        border-radius: 5px;
        animation: pulse 0.5s;
    }
    
    .barcode-input-container {
        display: flex;
        gap: 10px;
        position: relative;
    }
    
    .barcode-input {
        flex: 1;
        padding: 12px 15px;
        border: 2px solid #ddd;
        border-radius: 8px;
        font-size: 16px;
        transition: border-color 0.3s;
    }
    
    .barcode-input:focus {
        border-color: var(--secondary);
        outline: none;
    }
    
    .scan-button {
        background: var(--secondary);
        color: white;
        border: none;
        padding: 12px 20px;
        border-radius: 8px;
        cursor: pointer;
        font-size: 16px;
        transition: background 0.3s;
    }
    
    .scan-button:hover {
        background: #2980b9;
    }
    
    #suggestions {
        position: absolute;
        top: 50px;
        left: 0;
        width: 100%;
        background: white;
        border: 1px solid #ccc;
        z-index: 999;
        display: none;
        max-height: 200px;
        overflow-y: auto;
    }
    
    #suggestions div {
        padding: 10px;
        border-bottom: 1px solid #eee;
        cursor: pointer;
    }
    
    #suggestions div:hover {
        background: #f0f0f0;
    }
    
    /* Main Content */
    .main-content {
        display: grid;
        grid-template-columns: 1fr 350px;
        gap: 0;
        min-height: 500px;
    }
    
    .products-section {
        background: white;
        padding: 20px;
    }
    
    .product-table-container {
        max-height: 400px;
        overflow-y: auto;
        border: 1px solid #ddd;
        border-radius: 10px;
    }
    
    .product-table {
        width: 100%;
        border-collapse: collapse;
    }
    
    .product-table th {
        background: var(--primary);
        color: white;
        padding: 15px;
        text-align: left;
        font-weight: 600;
        position: sticky;
        top: 0;
    }
    
    .product-table td {
        padding: 12px 15px;
        border-bottom: 1px solid #eee;
    }
    
    .product-table tr:hover {
        background: #f8f9fa;
    }
    
    .product-quantity-input {
        width: 80px;
        padding: 8px;
        border: 1px solid #ddd;
        border-radius: 5px;
        text-align: center;
    }
    
    .delete-btn {
        color: var(--danger);
        font-size: 18px;
        transition: transform 0.3s;
        text-decoration: none;
    }
    
    .delete-btn:hover {
        transform: scale(1.2);
    }
    
    .low-stock {
        color: var(--danger);
        font-weight: bold;
        margin-left: 5px;
    }
    
    /* Transaction Section */
    .transaction-section {
        background: var(--dark);
        color: white;
        padding: 20px;
        border-left: 3px solid var(--secondary);
    }
    
    .section-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }
    
    .section-title {
        font-size: 20px;
        font-weight: 600;
        color: var(--warning);
    }
    
    .calc-link {
        background: var(--secondary);
        color: white;
        padding: 8px 15px;
        border-radius: 6px;
        text-decoration: none;
        font-size: 14px;
        transition: background 0.3s;
    }
    
    .calc-link:hover {
        background: #2980b9;
    }
    
    .payment-box {
        background: rgba(255,255,255,0.1);
        padding: 20px;
        border-radius: 10px;
        margin-bottom: 20px;
    }
    
    .detail-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 15px;
        padding: 10px 0;
        border-bottom: 1px solid rgba(255,255,255,0.1);
    }
    
    .detail-label {
        font-weight: 600;
        color: var(--light);
    }
    
    .detail-value {
        font-size: 18px;
        font-weight: 700;
        color: var(--warning);
    }
    
    .cash-input {
        width: 150px;
        padding: 10px;
        border: 2px solid var(--secondary);
        border-radius: 5px;
        font-size: 16px;
        font-weight: 600;
        text-align: right;
        background: white;
        color: var(--dark);
    }
    
    #payment_mode {
        width: 100%;
        padding: 10px;
        border: 2px solid #ddd;
        border-radius: 5px;
        font-size: 16px;
        background: white;
        color: var(--dark);
    }
    
    .complete-transaction {
        width: 100%;
        background: var(--success);
        color: white;
        border: none;
        padding: 15px;
        font-size: 18px;
        font-weight: 700;
        border-radius: 10px;
        cursor: pointer;
        transition: background 0.3s;
        margin-top: 10px;
    }
    
    .complete-transaction:hover {
        background: #219a52;
        transform: translateY(-2px);
    }
    
    /* Calculator Modal */
    #calculator-modal {
        display: none;
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        background: white;
        border-radius: 15px;
        padding: 20px;
        box-shadow: 0 20px 40px rgba(0,0,0,0.3);
        z-index: 1000;
        width: 300px;
    }
    
    #calc-header {
        background: var(--primary);
        color: white;
        padding: 15px;
        margin: -20px -20px 15px -20px;
        border-radius: 15px 15px 0 0;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    #calc-display {
        width: 100%;
        height: 50px;
        font-size: 24px;
        text-align: right;
        padding: 10px;
        margin-bottom: 15px;
        border: 2px solid #ddd;
        border-radius: 5px;
        background: #f8f9fa;
    }
    
    .calc-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 10px;
        margin-bottom: 10px;
    }
    
    .calc-btn, #calc-equals, #calc-clear {
        padding: 15px;
        border: none;
        border-radius: 5px;
        font-size: 18px;
        cursor: pointer;
        transition: background 0.3s;
    }
    
    .calc-btn {
        background: #f8f9fa;
    }
    
    .calc-btn:hover {
        background: #e9ecef;
    }
    
    #calc-equals {
        background: var(--success);
        color: white;
    }
    
    #calc-equals:hover {
        background: #219a52;
    }
    
    #calc-clear {
        background: var(--danger);
        color: white;
        grid-column: span 4;
    }
    
    #calc-clear:hover {
        background: #c0392b;
    }
    
    /* Net Total & Balance Popup */
    #net-balance-popup {
        display: none;
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        background: #000;
        color: #0f0;
        font-size: 28px;
        font-weight: bold;
        padding: 20px 40px;
        border-radius: 12px;
        text-align: center;
        box-shadow: 0 0 25px rgba(0,255,0,0.7);
        z-index: 3000;
    }
    
    /* Animations */
    @keyframes pulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.05); }
        100% { transform: scale(1); }
    }
    
    @keyframes blink {
        0%, 50%, 100% { opacity: 1; }
        25%, 75% { opacity: 0; }
    }
    
    .balance-negative {
        color: var(--danger) !important;
        animation: blink 1s infinite;
    }
    
    /* Responsive Design */
    @media (max-width: 1024px) {
        .main-content {
            grid-template-columns: 1fr;
        }
        
        .transaction-section {
            border-left: none;
            border-top: 3px solid var(--secondary);
        }
    }
    
    @media (max-width: 768px) {
        .barcode-section {
            grid-template-columns: 1fr;
        }
        
        header {
            flex-direction: column;
            gap: 15px;
            text-align: center;
        }
        
        .page-wrapper {
            margin: 10px;
        }
        
        .cash-input {
            width: 120px;
        }
    }
</style>
</head>
<body>
    <div class="page-wrapper">
        <div class="container">
            <header>
                <div class="cashier-info">
                    <div class="cashier-name">CASHIER: ADMIN USER</div>
                    <div class="txn-id">
                        Transaction: <?= $transactionId ?>
                        <span id="live-time"><?= date("l, h:i:s A") ?></span>
                    </div>
                </div>
                
                <div class="brand-logo">
                    <h2><span>MUWAKA</span> ENTERPRISE</h2>
                </div>
                
                <nav>
                    <a href="admin.php" class="home-link"><i class="fas fa-home"></i></a>
                </nav>
            </header>

            <!-- Barcode Input -->
            <div class="barcode-section">
                <div class="scan-display">
                    <div id="recent-scan-box">Scan a product to get started...</div>
                </div>
                <div class="barcode-input-container">
                    <input type="text" id="barcode-input" placeholder="Scan barcode or search product..." autocomplete="off" class="barcode-input">
                    <button type="button" class="scan-button" id="scan-button">
                        <i class="fas fa-barcode"></i> Scan
                    </button>
                    <div id="suggestions"></div>
                </div>
            </div>

            <div class="main-content">
                <div class="products-section">
                    <div class="product-table-container">
                        <table class="product-table">
                            <thead>
                                <tr>
                                    <th>Item Name</th>
                                    <th>Price</th>
                                    <th>Quantity</th>
                                    <th>Total</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                           <tbody id="product-list">
    <?php 
    $grandTotal = 0;
    $products = $_SESSION['cart'] ?? [];

    if (!empty($products)): 
        foreach ($products as $item):
            $lineTotal = $item['price'] * $item['qty'];
            $grandTotal += $lineTotal;

            $stockResult = $conn->query("SELECT quantity FROM products WHERE id=".$item['id']." LIMIT 1");
            $currentStock = $stockResult ? $stockResult->fetch_assoc()['quantity'] : 0;
            $lowStock = ($currentStock <= 5) ? '<span class="low-stock"><i class="fas fa-exclamation-triangle"></i></span>' : '';
    ?>
    <tr class="product-item" data-id="<?= $item['id'] ?>" data-stock="<?= $currentStock ?>">
        <td>
            <i class="fas fa-cube"></i> 
            <?= htmlspecialchars($item['name']) ?> 
            <?= $lowStock ?>
        </td>
        <td class="product-price" data-price="<?= $item['price'] ?>">
            KSH <?= number_format($item['price'], 2) ?>
        </td>
        <td>
            <input type="number" name="quantities[<?= $item['id'] ?>]" 
                   class="product-quantity-input" value="<?= $item['qty'] ?>" 
                   min="1" max="<?= $currentStock ?>" form="checkout-form">
        </td>
        <td class="product-total">
            KSH <?= number_format($lineTotal, 2) ?>
        </td>
        <td>
            <a href="?delete=<?= $item['id'] ?>" class="delete-btn" title="Remove item">
                <i class="fas fa-trash"></i>
            </a>
        </td>
    </tr>
    <?php 
        endforeach;
    else: 
    ?>
    <tr id="empty-cart-message">
        <td colspan="5" style="text-align: center; padding: 40px; color: var(--gray);">
            <i class="fas fa-shopping-cart" style="font-size: 48px; margin-bottom: 10px;"></i>
            <br>No products added yet. Scan a barcode to start.
        </td>
    </tr>
    <?php endif; ?>
</tbody>
                        </table>
                    </div>
                </div>

                <!-- Transaction Section -->
                <div class="transaction-section">
                    <div class="section-header">
                        <h3 class="section-title"><i class="fas fa-receipt"></i> Transaction Summary</h3>
                        <a href="#" id="open-calculator" class="calc-link">
                            <i class="fas fa-calculator"></i> Calculator
                        </a>
                    </div>

                    <form id="checkout-form" action="Cashier.php" method="post">
                        <div class="payment-box">
                            <?php 
                            $vatRate = 0.00;
                            $vatAmount = $grandTotal * $vatRate;
                            $netTotal = $grandTotal + $vatAmount;
                            ?>

                            <div class="detail-row">
                                <span class="detail-label">Subtotal:</span>
                                <span class="detail-value" id="total-amount">KSH <?= number_format($grandTotal, 2) ?></span>
                                <input type="hidden" name="subtotal" id="subtotal-hidden" value="<?= $grandTotal ?>">
                            </div>
                            
                            <div class="detail-row">
                                <span class="detail-label">VAT (0.00%):</span>
                                <span class="detail-value" id="vat-amount">KSH <?= number_format($vatAmount, 2) ?></span>
                            </div>
                            
                            <div class="detail-row" style="border-bottom: 2px solid var(--warning);">
                                <span class="detail-label">Net Total:</span>
                                <span class="detail-value" id="net-total">KSH <?= number_format($netTotal, 2) ?></span>
                                <input type="hidden" name="net_total" id="net-total-hidden" value="<?= $netTotal ?>">
                            </div>

                            <div class="detail-row">
                                <span class="detail-label">Cash Received:</span>
                                <input type="number" name="cash_received" class="cash-input" id="cash-input" 
                                       value="0.00" min="0" step="0.01" required>
                            </div>

                            <div class="detail-row">
                                <span class="detail-label">Balance:</span>
                                <span class="detail-value" id="balance-amount">KSH 0.00</span>
                                <input type="hidden" name="balance" id="balance-hidden" value="0.00">
                            </div>

                            <div class="detail-row">
                                <span class="detail-label">Payment Method:</span>
                                <select name="payment_mode" id="payment_mode" required>
                                    <option value="cash" selected>Cash</option>
                                    <option value="mpesa">M-Pesa</option>
                                    <option value="card">Credit Card</option>
                                </select>
                            </div>
                        </div>

                        <button type="submit" id="complete-transaction" name="complete_transaction" class="complete-transaction">
                            <i class="fas fa-check-circle"></i> COMPLETE TRANSACTION
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Calculator Modal -->
    <div id="calculator-modal">
        <div id="calc-header">
            <strong>Calculator</strong>
            <button id="close-calculator" style="background: none; border: none; color: white; font-size: 18px; cursor: pointer;">✖</button>
        </div>
        <input type="text" id="calc-display" disabled>
        <div class="calc-grid">
            <button class="calc-btn">7</button>
            <button class="calc-btn">8</button>
            <button class="calc-btn">9</button>
            <button class="calc-btn">/</button>
            <button class="calc-btn">4</button>
            <button class="calc-btn">5</button>
            <button class="calc-btn">6</button>
            <button class="calc-btn">*</button>
            <button class="calc-btn">1</button>
            <button class="calc-btn">2</button>
            <button class="calc-btn">3</button>
            <button class="calc-btn">-</button>
            <button class="calc-btn">0</button>
            <button class="calc-btn">.</button>
            <button id="calc-equals">=</button>
            <button class="calc-btn">+</button>
        </div>
        <button id="calc-clear">Clear</button>
    </div>

    <!-- Net Total & Balance Popup -->
    <div id="net-balance-popup">
        <div><span id="popup-net"></span></div>
    </div>

 <script>
// ================== GLOBAL VARIABLES ==================
let typingTimer;
let currentInput = "";
let isScannerInput = false;
let lastInputTime = 0;
let cartItems = []; // Array to track cart items with timestamps

// ================== INITIALIZATION ==================
document.addEventListener("DOMContentLoaded", function () {
    initializeApp();
});

function initializeApp() {
    updateClock();
    updateTotals();
    setupBarcodeScanner();
    setupEventListeners();
    
    // Initialize cartItems from existing cart
    initializeCartItems();
    
    // Auto-focus barcode input
    setTimeout(() => {
        focusBarcodeInput();
    }, 500);
}

// ================== INITIALIZE CART ITEMS ==================
function initializeCartItems() {
    const productRows = document.querySelectorAll('#product-list tr.product-item');
    cartItems = [];
    
    productRows.forEach(row => {
        const productId = parseInt(row.dataset.id);
        const productName = row.querySelector('td:first-child').textContent.trim();
        const productPrice = parseFloat(row.querySelector('.product-price').dataset.price);
        const quantity = parseInt(row.querySelector('.product-quantity-input').value);
        
        cartItems.push({
            id: productId,
            name: productName,
            price: productPrice,
            quantity: quantity,
            timestamp: Date.now() // Add current timestamp for existing items
        });
    });
    
    // Sort by timestamp (newest first)
    sortCartItems();
}

// ================== SORT CART ITEMS ==================
function sortCartItems() {
    cartItems.sort((a, b) => b.timestamp - a.timestamp);
}

// ================== EVENT LISTENERS SETUP ==================
function setupEventListeners() {
    const barcodeInput = document.getElementById("barcode-input");
    const cashInput = document.getElementById("cash-input");
    const suggestionBox = document.getElementById("suggestions");
    
    // Barcode input handling
    barcodeInput.addEventListener("input", handleBarcodeInput);
    barcodeInput.addEventListener("keydown", handleBarcodeKeydown);
    barcodeInput.addEventListener("keypress", detectScannerInput);
    
    // Scan button
    document.getElementById("scan-button").addEventListener("click", function() {
        const code = barcodeInput.value.trim();
        if (code) handleBarcodeScan(code);
    });
    
    // Cash input handling
    cashInput.addEventListener("focus", handleCashFocus);
    cashInput.addEventListener("blur", handleCashBlur);
    cashInput.addEventListener("input", updateTotals);
    
    // Calculator functionality
    setupCalculator();
    
    // Payment mode change
    document.getElementById("payment_mode").addEventListener("change", function() {
        console.log("Payment mode changed to:", this.value);
    });
    
    // Form submission
    document.getElementById("checkout-form").addEventListener("submit", handleFormSubmit);
    
    // Keyboard shortcuts
    document.addEventListener("keydown", handleKeyboardShortcuts);
    
    // Click outside suggestions
    document.addEventListener("click", function(e) {
        if (!barcodeInput.contains(e.target) && !suggestionBox.contains(e.target)) {
            suggestionBox.style.display = "none";
        }
    });
    
    // Quantity input changes
    document.addEventListener("input", function(e) {
        if (e.target.classList.contains("product-quantity-input")) {
            validateQuantity(e.target);
            updateTotals();
        }
    });
}

// ================== SCANNER DETECTION ==================
function detectScannerInput(e) {
    const currentTime = new Date().getTime();
    const timeDiff = currentTime - lastInputTime;
    
    // If keystrokes are very fast (less than 50ms), it's likely a scanner
    if (timeDiff < 50) {
        isScannerInput = true;
    } else {
        isScannerInput = false;
    }
    
    lastInputTime = currentTime;
}

// ================== IMPROVED BARCODE INPUT HANDLING ==================
function handleBarcodeInput() {
    clearTimeout(typingTimer);
    const barcodeInput = document.getElementById("barcode-input");
    const code = barcodeInput.value.trim();
    
    // Different timeouts for scanner vs manual input
    const timeoutDelay = isScannerInput ? 100 : 300;
    
    typingTimer = setTimeout(() => {
        if (code.length > 0) {
            // Always try barcode scan first for numeric input
            if (/^\d+$/.test(code) && code.length >= 3) {
                handleBarcodeScan(code);
            } 
            // For mixed input, try both search and scan
            else if (code.length >= 2) {
                // First try product search by name
                handleProductSearch(code);
                
                // Also try barcode scan if it contains numbers (might be a barcode with prefixes)
                if (/\d/.test(code)) {
                    setTimeout(() => handleBarcodeScan(code), 200);
                }
            }
        } else {
            document.getElementById("suggestions").style.display = "none";
        }
    }, timeoutDelay);
}

// ================== IMPROVED BARCODE SCANNING ==================
function handleBarcodeScan(barcode) {
    // Clean the barcode - remove any extra characters
    const cleanBarcode = barcode.replace(/[\r\n\t]/g, '').trim();
    
    if (!cleanBarcode) {
        showNotification("Please scan a valid barcode", "warning");
        return;
    }
    
    console.log("Scanning barcode:", cleanBarcode);
    
    fetch("Cashier.php", {
        method: "POST",
        headers: {"Content-Type": "application/x-www-form-urlencoded"},
        body: "barcode=" + encodeURIComponent(cleanBarcode) + "&ajax=1"
    })
    .then(res => res.json())
    .then(product => {
        if (product.success) {
            addToCart(product);
            document.getElementById("barcode-input").value = "";
            document.getElementById("suggestions").style.display = "none";
            updateTotals();
            showNotification(`✓ ${product.name} added`, "success");
        } else {
            // If barcode scan fails, try searching by the input as product name
            handleProductSearch(cleanBarcode);
        }
    })
    .catch(error => {
        console.error("Error scanning barcode:", error);
        // Fallback to product search
        handleProductSearch(cleanBarcode);
    });
}

// ================== IMPROVED PRODUCT SEARCH ==================
function handleProductSearch(searchTerm) {
    if (searchTerm.length < 2) {
        document.getElementById("suggestions").style.display = "none";
        return;
    }
    
    console.log("Searching for product:", searchTerm);
    
    fetch("Cashier.php", {
        method: "POST",
        headers: {"Content-Type": "application/x-www-form-urlencoded"},
        body: "search_name=" + encodeURIComponent(searchTerm) + "&ajax=1"
    })
    .then(res => res.json())
    .then(products => {
        if (products && products.length > 0) {
            displaySearchSuggestions(products);
            
            // Auto-select if only one product found
            if (products.length === 1) {
                setTimeout(() => {
                    autoSelectProduct(products[0]);
                }, 500);
            }
        } else {
            document.getElementById("suggestions").style.display = "none";
            showNotification("No products found matching: " + searchTerm, "warning");
        }
    })
    .catch(error => {
        console.error("Error searching products:", error);
        document.getElementById("suggestions").style.display = "none";
    });
}

// ================== AUTO-SELECT SINGLE PRODUCT ==================
function autoSelectProduct(product) {
    const barcodeInput = document.getElementById("barcode-input");
    const currentValue = barcodeInput.value.trim();
    
    // Only auto-select if the search term matches the beginning of the product name
    if (product.name.toLowerCase().includes(currentValue.toLowerCase())) {
        const productData = {
            success: true,
            id: product.id,
            name: product.name,
            sale_price: product.sale_price,
            barcode: product.barcode
        };
        
        addToCart(productData);
        barcodeInput.value = "";
        document.getElementById("suggestions").style.display = "none";
        updateTotals();
        showNotification(`✓ ${product.name} added automatically`, "success");
    }
}

// ================== IMPROVED SUGGESTIONS DISPLAY ==================
function displaySearchSuggestions(products) {
    const suggestionBox = document.getElementById("suggestions");
    
    if (!products || products.length === 0) {
        suggestionBox.style.display = "none";
        return;
    }
    
    let suggestionsHtml = "";
    products.forEach((product, index) => {
        const isExactMatch = product.name.toLowerCase() === document.getElementById("barcode-input").value.toLowerCase();
        const highlightClass = isExactMatch ? 'exact-match' : '';
        
        suggestionsHtml += `
            <div class="suggestion-item ${highlightClass} ${index === 0 ? 'selected' : ''}" 
                 data-id="${product.id}" 
                 data-name="${product.name}" 
                 data-price="${product.sale_price}"
                 data-barcode="${product.barcode}">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <div style="flex: 1;">
                        <strong>${product.name}</strong>
                        <br>
                        <small style="color: #666;">Barcode: ${product.barcode}</small>
                    </div>
                    <div style="color: var(--success); font-weight: bold; margin-left: 15px;">
                        KSH ${parseFloat(product.sale_price).toFixed(2)}
                    </div>
                </div>
            </div>
        `;
    });
    
    suggestionBox.innerHTML = suggestionsHtml;
    suggestionBox.style.display = "block";
    
    // Add click handlers for suggestions
    suggestionBox.querySelectorAll('.suggestion-item').forEach(item => {
        item.addEventListener('click', function() {
            selectProductFromSuggestion(this);
        });
        
        // Add hover effect
        item.addEventListener('mouseenter', function() {
            this.style.backgroundColor = "#e3f2fd";
            suggestionBox.querySelectorAll('.suggestion-item').forEach(i => i.classList.remove('selected'));
            this.classList.add('selected');
        });
        
        item.addEventListener('mouseleave', function() {
            if (!this.classList.contains('selected')) {
                this.style.backgroundColor = "white";
            }
        });
    });
}

function selectProductFromSuggestion(suggestionElement) {
    const productData = {
        success: true,
        id: suggestionElement.dataset.id,
        name: suggestionElement.dataset.name,
        sale_price: suggestionElement.dataset.price,
        barcode: suggestionElement.dataset.barcode
    };
    
    addToCart(productData);
    document.getElementById("barcode-input").value = "";
    document.getElementById("suggestions").style.display = "none";
    updateTotals();
    showNotification(`✓ ${productData.name} added`, "success");
    focusBarcodeInput();
}

// ================== IMPROVED KEYBOARD NAVIGATION ==================
function handleBarcodeKeydown(e) {
    const suggestionBox = document.getElementById("suggestions");
    const suggestions = suggestionBox.querySelectorAll('.suggestion-item');
    
    if (e.key === "Enter") {
        e.preventDefault();
        
        // If suggestions are visible, select the highlighted one
        if (suggestionBox.style.display === "block" && suggestions.length > 0) {
            const selected = suggestionBox.querySelector('.suggestion-item.selected');
            if (selected) {
                selectProductFromSuggestion(selected);
                return;
            }
        }
        
        // No suggestions - process current input
        const code = document.getElementById("barcode-input").value.trim();
        if (code) {
            if (/^\d+$/.test(code)) {
                handleBarcodeScan(code);
            } else {
                // For text input, try to add the first matching product
                if (suggestions.length > 0) {
                    selectProductFromSuggestion(suggestions[0]);
                } else {
                    showNotification("No matching products found", "warning");
                }
            }
        }
    }
    
    // Arrow key navigation in suggestions
    if ((e.key === "ArrowDown" || e.key === "ArrowUp") && suggestionBox.style.display === "block") {
        e.preventDefault();
        navigateSuggestions(e.key, suggestions);
    }
    
    if (e.key === "Escape") {
        suggestionBox.style.display = "none";
        focusBarcodeInput();
    }
    
    // Tab key to cycle through suggestions
    if (e.key === "Tab" && suggestionBox.style.display === "block" && suggestions.length > 0) {
        e.preventDefault();
        navigateSuggestions("ArrowDown", suggestions);
    }
}

function navigateSuggestions(direction, suggestions) {
    const currentSelected = document.querySelector('.suggestion-item.selected');
    let newIndex = 0;
    
    if (currentSelected) {
        currentSelected.classList.remove('selected');
        currentSelected.style.backgroundColor = "white";
        const currentIndex = Array.from(suggestions).indexOf(currentSelected);
        
        if (direction === "ArrowDown") {
            newIndex = (currentIndex + 1) % suggestions.length;
        } else {
            newIndex = (currentIndex - 1 + suggestions.length) % suggestions.length;
        }
    }
    
    suggestions[newIndex].classList.add('selected');
    suggestions[newIndex].style.backgroundColor = "#e3f2fd";
    suggestions[newIndex].scrollIntoView({ block: 'nearest' });
}

// ================== IMPROVED BARCODE SCANNER SETUP ==================
function setupBarcodeScanner() {
    const barcodeInput = document.getElementById("barcode-input");
    let scannerBuffer = "";
    let scannerTimeout;
    
    // Detect scanner input (rapid character entry followed by Enter or Tab)
    barcodeInput.addEventListener('keydown', function(e) {
        // Ignore if it's not a character key or Enter/Tab
        if (e.key.length === 1 || e.key === 'Enter' || e.key === 'Tab') {
            scannerBuffer += e.key;
            
            clearTimeout(scannerTimeout);
            scannerTimeout = setTimeout(() => {
                // If buffer ends with Enter/Tab and has reasonable length, it's a scanner
                if ((scannerBuffer.endsWith('Enter') || scannerBuffer.endsWith('Tab')) && 
                    scannerBuffer.length > 3) {
                    const scannedCode = scannerBuffer.slice(0, -5).replace(/[\r\n\t]/g, '').trim();
                    if (scannedCode.length >= 3) {
                        setTimeout(() => {
                            handleBarcodeScan(scannedCode);
                        }, 100);
                    }
                }
                scannerBuffer = "";
            }, 150);
        }
    });
}

// ================== CART MANAGEMENT ==================
function addToCart(product) {
    // Remove empty cart message
    const emptyMessage = document.getElementById('empty-cart-message');
    if (emptyMessage) {
        emptyMessage.remove();
    }
    
    const productList = document.getElementById("product-list");
    const existingRow = document.querySelector(`#product-list tr[data-id="${product.id}"]`);
    
    if (existingRow) {
        // Update existing product quantity
        const qtyInput = existingRow.querySelector(".product-quantity-input");
        const currentStock = parseInt(existingRow.dataset.stock) || 999;
        const newQty = parseInt(qtyInput.value) + 1;
        
        if (newQty <= currentStock) {
            qtyInput.value = newQty;
            
            // Update cartItems array
            updateCartItemQuantity(product.id, newQty);
        } else {
            showNotification(`Only ${currentStock} items available!`, "warning");
            qtyInput.value = currentStock;
        }
    } else {
        // Add new product row
        const stockResult = getProductStock(product.id);
        const currentStock = stockResult ? stockResult.quantity : 999;
        const lowStock = currentStock <= 5 ? '<span class="low-stock"><i class="fas fa-exclamation-triangle"></i></span>' : '';
        
        const newRow = `
            <tr class="product-item" data-id="${product.id}" data-stock="${currentStock}">
                <td>
                    <i class="fas fa-cube"></i> 
                    ${product.name} 
                    ${lowStock}
                </td>
                <td class="product-price" data-price="${product.sale_price}">
                    KSH ${parseFloat(product.sale_price).toFixed(2)}
                </td>
                <td>
                    <input type="number" name="quantities[${product.id}]" 
                           class="product-quantity-input" value="1" 
                           min="1" max="${currentStock}" form="checkout-form">
                </td>
                <td class="product-total">
                    KSH ${parseFloat(product.sale_price).toFixed(2)}
                </td>
                <td>
                    <a href="?delete=${product.id}" class="delete-btn" title="Remove item">
                        <i class="fas fa-trash"></i>
                    </a>
                </td>
            </tr>`;
        productList.insertAdjacentHTML("beforeend", newRow);
        
        // Add to cartItems array with timestamp
        cartItems.push({
            id: product.id,
            name: product.name,
            price: product.sale_price,
            quantity: 1,
            timestamp: Date.now()
        });
        
        // Sort cart items (newest first)
        sortCartItems();
        
        // Re-render cart table with sorted items
        renderCartTable();
    }

    // Update session cart
    updateSessionCart(product);
    updateRecentScan(product);
    updateTotals();
}

// ================== UPDATE CART ITEM QUANTITY ==================
function updateCartItemQuantity(productId, newQuantity) {
    const itemIndex = cartItems.findIndex(item => item.id === productId);
    if (itemIndex !== -1) {
        cartItems[itemIndex].quantity = newQuantity;
        cartItems[itemIndex].timestamp = Date.now(); // Update timestamp
        sortCartItems();
        renderCartTable();
    }
}

// ================== RENDER CART TABLE ==================
function renderCartTable() {
    const productList = document.getElementById("product-list");
    const emptyMessage = document.getElementById('empty-cart-message');
    
    // Remove empty message if it exists
    if (emptyMessage) {
        emptyMessage.remove();
    }
    
    // Clear current table rows (except header)
    const currentRows = productList.querySelectorAll('tr.product-item');
    currentRows.forEach(row => row.remove());
    
    // Add rows in sorted order (newest first)
    cartItems.forEach(item => {
        const stockResult = getProductStock(item.id);
        const currentStock = stockResult ? stockResult.quantity : 999;
        const lowStock = currentStock <= 5 ? '<span class="low-stock"><i class="fas fa-exclamation-triangle"></i></span>' : '';
        const lineTotal = item.price * item.quantity;
        
        const newRow = `
            <tr class="product-item" data-id="${item.id}" data-stock="${currentStock}">
                <td>
                    <i class="fas fa-cube"></i> 
                    ${item.name} 
                    ${lowStock}
                </td>
                <td class="product-price" data-price="${item.price}">
                    KSH ${parseFloat(item.price).toFixed(2)}
                </td>
                <td>
                    <input type="number" name="quantities[${item.id}]" 
                           class="product-quantity-input" value="${item.quantity}" 
                           min="1" max="${currentStock}" form="checkout-form">
                </td>
                <td class="product-total">
                    KSH ${parseFloat(lineTotal).toFixed(2)}
                </td>
                <td>
                    <a href="?delete=${item.id}" class="delete-btn" title="Remove item">
                        <i class="fas fa-trash"></i>
                    </a>
                </td>
            </tr>`;
        productList.insertAdjacentHTML("beforeend", newRow);
    });
    
    // Add event listeners to new quantity inputs
    productList.querySelectorAll('.product-quantity-input').forEach(input => {
        input.addEventListener('input', function() {
            validateQuantity(this);
            updateTotals();
            
            // Update cartItems array
            const productId = parseInt(this.name.match(/quantities\[(\d+)\]/)[1]);
            const newQuantity = parseInt(this.value) || 1;
            updateCartItemQuantity(productId, newQuantity);
        });
    });
    
    // If cart is empty, show empty message
    if (cartItems.length === 0) {
        productList.innerHTML = `
            <tr id="empty-cart-message">
                <td colspan="5" style="text-align: center; padding: 40px; color: var(--gray);">
                    <i class="fas fa-shopping-cart" style="font-size: 48px; margin-bottom: 10px;"></i>
                    <br>No products added yet. Scan a barcode to start.
                </td>
            </tr>
        `;
    }
}

// ================== HANDLE DELETE ITEM ==================
// Override the default delete behavior to use our cartItems array
document.addEventListener('click', function(e) {
    if (e.target.closest('.delete-btn')) {
        e.preventDefault();
        const deleteLink = e.target.closest('.delete-btn');
        const productId = parseInt(deleteLink.href.split('delete=')[1]);
        
        // Remove from cartItems array
        cartItems = cartItems.filter(item => item.id !== productId);
        
        // Re-render cart table
        renderCartTable();
        updateTotals();
        
        // Show notification
        showNotification('Item removed from cart', 'success');
        
        // Update session via AJAX
        fetch(deleteLink.href);
    }
});

function updateSessionCart(product) {
    fetch("Cashier.php", {
        method: "POST",
        headers: {"Content-Type": "application/x-www-form-urlencoded"},
        body: "update_cart=1&product_id=" + product.id +
              "&product_name=" + encodeURIComponent(product.name) +
              "&product_price=" + product.sale_price
    });
}

function validateQuantity(input) {
    const maxStock = parseInt(input.getAttribute("max"));
    const enteredQty = parseInt(input.value) || 1;
    
    if (enteredQty > maxStock) {
        showNotification(`Quantity cannot exceed available stock (${maxStock})`, "warning");
        input.value = maxStock;
    }
    
    if (enteredQty < 1) {
        input.value = 1;
    }
}

// ================== RECENT SCAN DISPLAY ==================
function updateRecentScan(product) {
    const recentBox = document.getElementById("recent-scan-box");
    recentBox.innerHTML = `
        <div style="text-align: center;">
            <div style="font-weight: bold; margin-bottom: 5px;">${product.name}</div>
            <div style="color: var(--success); font-size: 18px;">
                KSH ${parseFloat(product.sale_price).toFixed(2)}
            </div>
        </div>
    `;

    recentBox.classList.add("active");
    setTimeout(() => recentBox.classList.remove("active"), 2000);
}

// ================== CALCULATIONS & TOTALS ==================
function updateTotals() {
    let grandTotal = 0;

    // Loop all product rows
    document.querySelectorAll("#product-list tr.product-item").forEach(row => {
        const price = parseFloat(row.querySelector(".product-price").dataset.price);
        const qty = parseInt(row.querySelector(".product-quantity-input").value) || 1;
        const lineTotal = price * qty;

        // Update line total cell
        row.querySelector(".product-total").textContent = "KSH " + lineTotal.toFixed(2);

        grandTotal += lineTotal;
    });

    // SET VAT TO ZERO
    const vatRate = 0.00; // Changed from 0.16 to 0.00
    const vatAmount = 0.00; // Directly set to zero
    const netTotal = grandTotal; // Net total equals grand total since VAT is zero
    const cashReceived = parseFloat(document.getElementById("cash-input").value) || 0;
    const balance = cashReceived - netTotal;

    // Update summary
    document.getElementById("total-amount").textContent = "KSH " + grandTotal.toFixed(2);
    document.getElementById("subtotal-hidden").value = grandTotal.toFixed(2);

    // Update VAT display to show zero
    document.getElementById("vat-amount").textContent = "KSH " + vatAmount.toFixed(2);
    document.getElementById("net-total").textContent = "KSH " + netTotal.toFixed(2);
    document.getElementById("net-total-hidden").value = netTotal.toFixed(2);

    const balanceElement = document.getElementById("balance-amount");
    balanceElement.textContent = "KSH " + balance.toFixed(2);
    document.getElementById("balance-hidden").value = balance.toFixed(2);

    // Highlight negative balance
    if (balance < 0) {
        balanceElement.classList.add("balance-negative");
    } else {
        balanceElement.classList.remove("balance-negative");
    }
}

// ================== CASH INPUT HANDLING ==================
function handleCashFocus() {
    if (this.value === "0.00" || this.value === "0") {
        this.value = "";
    }
}

function handleCashBlur() {
    if (this.value.trim() === "" || isNaN(parseFloat(this.value))) {
        this.value = "0.00";
    } else {
        this.value = parseFloat(this.value).toFixed(2);
    }
    updateTotals();
}

// ================== CALCULATOR FUNCTIONALITY ==================
function setupCalculator() {
    const calcModal = document.getElementById("calculator-modal");
    const calcDisplay = document.getElementById("calc-display");
    const openCalcBtn = document.getElementById("open-calculator");
    const closeCalcBtn = document.getElementById("close-calculator");
    
    // Open calculator
    openCalcBtn.addEventListener("click", function(e) {
        e.preventDefault();
        calcModal.style.display = "block";
        calcDisplay.value = "";
        currentInput = "";
    });
    
    // Close calculator
    closeCalcBtn.addEventListener("click", closeCalculator);
    
    // Calculator buttons
    document.querySelectorAll(".calc-btn").forEach(button => {
        button.addEventListener("click", function() {
            currentInput += this.textContent;
            calcDisplay.value = currentInput;
        });
    });
    
    // Equals button
    document.getElementById("calc-equals").addEventListener("click", function() {
        try {
            const result = eval(currentInput);
            if (isFinite(result)) {
                currentInput = result.toString();
                calcDisplay.value = currentInput;
                
                // Transfer result to cash input after short delay
                setTimeout(() => {
                    document.getElementById("cash-input").value = parseFloat(result).toFixed(2);
                    updateTotals();
                }, 100);
            } else {
                throw new Error("Invalid calculation");
            }
        } catch {
            calcDisplay.value = "Error";
            currentInput = "";
        }
    });
    
    // Clear button
    document.getElementById("calc-clear").addEventListener("click", function() {
        currentInput = "";
        calcDisplay.value = "";
    });
    
    // Close calculator when clicking outside
    window.addEventListener("click", function(e) {
        if (e.target === calcModal) {
            closeCalculator();
        }
    });
}

function closeCalculator() {
    document.getElementById("calculator-modal").style.display = "none";
}

// ================== NET TOTAL POPUP ==================
function toggleNetTotalPopup() {
    const popup = document.getElementById("net-balance-popup");
    if (popup.style.display === "block") {
        popup.style.display = "none";
    } else {
        const netTotal = document.getElementById("net-total").textContent;
        document.getElementById("popup-net").textContent = netTotal;
        popup.style.display = "block";
        
        // Auto-hide after 3 seconds
        setTimeout(() => {
            popup.style.display = "none";
        }, 3000);
    }
}

// ================== FORM VALIDATION ==================
function handleFormSubmit(e) {
    const cashInput = parseFloat(document.getElementById("cash-input").value) || 0;
    const netTotal = parseFloat(document.getElementById("net-total-hidden").value) || 0;
    const productCount = cartItems.length;
    const paymentMode = document.getElementById("payment_mode").value;
    
    if (productCount === 0) {
        e.preventDefault();
        showNotification("Please add at least one product to complete the transaction.", "warning");
        focusBarcodeInput();
        return;
    }
    
    if (paymentMode === "cash" && cashInput < netTotal) {
        e.preventDefault();
        showNotification("Cash received is less than the net total. Please enter sufficient amount.", "warning");
        document.getElementById("cash-input").focus();
        document.getElementById("cash-input").select();
        return;
    }
    
    // All validations passed - allow form submission
    showNotification("Processing transaction...", "success");
}

// ================== COMPLETE TRANSACTION FUNCTION ==================
function completeTransaction() {
    const cashInput = parseFloat(document.getElementById("cash-input").value) || 0;
    const netTotal = parseFloat(document.getElementById("net-total-hidden").value) || 0;
    const productCount = cartItems.length;
    const paymentMode = document.getElementById("payment_mode").value;
    
    // Validation
    if (productCount === 0) {
        showNotification("Please add at least one product to complete the transaction.", "warning");
        focusBarcodeInput();
        return false;
    }
    
    if (paymentMode === "cash" && cashInput < netTotal) {
        showNotification("Cash received is less than the net total. Please enter sufficient amount.", "warning");
        document.getElementById("cash-input").focus();
        document.getElementById("cash-input").select();
        return false;
    }
    
    // Show processing notification
    showNotification("Processing transaction...", "success");
    
    // Submit the form programmatically
    document.getElementById("checkout-form").submit();
    
    return true;
}

// ================== KEYBOARD SHORTCUTS ==================
function handleKeyboardShortcuts(e) {
    // Enter - Complete transaction (when not in input fields)
    if (e.key === 'Enter' && !e.target.matches('input, textarea, select')) {
        e.preventDefault();
        completeTransaction();
    }
    
    // F2 - Focus barcode input
    if (e.key === 'F2') {
        e.preventDefault();
        focusBarcodeInput();
    }
    
    // F4 - Open calculator
    if (e.key === 'F4') {
        e.preventDefault();
        document.getElementById('open-calculator').click();
    }
    
    // Arrow Up - Toggle net total popup
    if (e.key === 'ArrowUp') {
        e.preventDefault();
        toggleNetTotalPopup();
    }
    
    // Ctrl + Enter - Also complete transaction
    if (e.ctrlKey && e.key === 'Enter') {
        e.preventDefault();
        completeTransaction();
    }
    
    // Spacebar - Quick scan focus
    if (e.key === ' ' && !e.target.matches('input, textarea')) {
        e.preventDefault();
        focusBarcodeInput();
    }
}

// ================== UTILITY FUNCTIONS ==================
function focusBarcodeInput() {
    const barcodeInput = document.getElementById("barcode-input");
    barcodeInput.focus();
    barcodeInput.select();
}

function updateClock() {
    const now = new Date();
    const options = { 
        weekday: 'long', 
        hour: '2-digit', 
        minute: '2-digit', 
        second: '2-digit',
        hour12: true 
    };
    document.getElementById('live-time').textContent = now.toLocaleDateString('en-US', options);
}

function getProductStock(productId) {
    // This would typically make an AJAX call to get current stock
    // For now, we'll get it from the data attribute if available
    const productRow = document.querySelector(`tr[data-id="${productId}"]`);
    if (productRow) {
        return { quantity: parseInt(productRow.dataset.stock) || 999 };
    }
    return null;
}

function showNotification(message, type = "info") {
    // Remove existing notifications
    document.querySelectorAll('.custom-notification').forEach(n => n.remove());
    
    // Create notification element
    const notification = document.createElement("div");
    notification.className = "custom-notification";
    notification.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        padding: 15px 20px;
        border-radius: 8px;
        color: white;
        font-weight: bold;
        z-index: 10000;
        animation: slideInRight 0.3s ease-out;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    `;
    
    const colors = {
        success: "#27ae60",
        error: "#e74c3c",
        warning: "#f39c12",
        info: "#3498db"
    };
    
    notification.style.background = colors[type] || colors.info;
    notification.innerHTML = `
        <i class="fas fa-${type === 'success' ? 'check' : type === 'error' ? 'exclamation-triangle' : type === 'warning' ? 'exclamation-circle' : 'info'}"></i>
        ${message}
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.style.animation = "slideOutRight 0.3s ease-in";
        setTimeout(() => {
            if (notification.parentNode) {
                notification.parentNode.removeChild(notification);
            }
        }, 300);
    }, 3000);
}

// Add CSS animations for notifications
const style = document.createElement('style');
style.textContent = `
    @keyframes slideInRight {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    @keyframes slideOutRight {
        from { transform: translateX(0); opacity: 1; }
        to { transform: translateX(100%); opacity: 0; }
    }
    
    .suggestion-item.exact-match {
        border-left: 4px solid #27ae60;
        background-color: #f8fff8 !important;
    }
    
    .suggestion-item.selected {
        background-color: #e3f2fd !important;
        border-left: 4px solid #3498db;
    }
    
    .custom-notification i {
        margin-right: 8px;
    }
    
    @keyframes pulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.05); }
        100% { transform: scale(1); }
    }
    
    @keyframes blink {
        0%, 50%, 100% { opacity: 1; }
        25%, 75% { opacity: 0; }
    }
    
    .balance-negative {
        color: var(--danger) !important;
        animation: blink 1s infinite;
    }
`;
document.head.appendChild(style);

// Initialize clock update
setInterval(updateClock, 1000);
</script>

</body>
</html>