<?php
require_once('includes/load.php');

// DB config
$host = "localhost";
$user = "root";
$pass = "";
$dbname = "inventory_syste";

$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Initialize cart if not set
if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

// Generate Transaction ID for session
$transactionId = $_SESSION['txn_id'] ?? null;

if (!isset($_SESSION['txn_id'])) {
    $_SESSION['txn_id'] = uniqid("TXN");
}

/* ================================
   AJAX: Handle barcode scan
   ================================ */
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['barcode']) && isset($_POST['ajax'])) {
    $barcode = $conn->real_escape_string(trim($_POST['barcode']));
    $sql = "SELECT id, barcode, name, sale_price FROM products WHERE barcode = '$barcode' LIMIT 1";
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        $product = $result->fetch_assoc();
        echo json_encode(["success" => true] + $product);
    } else {
        echo json_encode(["success" => false]);
    }
    exit;
}

/* ================================
   AJAX: Search product by name
   ================================ */
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['search_name']) && isset($_POST['ajax'])) {
    $term = $conn->real_escape_string(trim($_POST['search_name']));
    $sql = "SELECT id, barcode, name, sale_price 
            FROM products 
            WHERE name LIKE '%$term%' 
            ORDER BY name ASC 
            LIMIT 10";
    $result = $conn->query($sql);

    $products = [];
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $products[] = $row;
        }
    }
    echo json_encode($products);
    exit;
}

/* ================================
   AJAX: Update session cart
   ================================ */
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['update_cart'])) {
    $id = intval($_POST['product_id']);
    $name = $conn->real_escape_string($_POST['product_name']);
    $price = floatval($_POST['product_price']);

    $found = false;
    foreach ($_SESSION['cart'] as &$item) {
        if ($item['id'] == $id) {
            $item['qty'] += 1;
            $found = true;
            break;
        }
    }
    if (!$found) {
        $_SESSION['cart'][] = [
            'id' => $id,
            'name' => $name,
            'price' => $price,
            'qty' => 1
        ];
    }
    exit;
}

/* ================================
   Handle delete item
   ================================ */
if (isset($_GET['delete'])) {
    $deleteId = intval($_GET['delete']);
    foreach ($_SESSION['cart'] as $key => $item) {
        if ($item['id'] == $deleteId) {
            unset($_SESSION['cart'][$key]);
            break;
        }
    }
    $_SESSION['cart'] = array_values($_SESSION['cart']);
    header("Location: Cashier.php");
    exit;
}

/* ================================
   Handle complete transaction
   ================================ */
/* ================================
   Handle complete transaction
   ================================ */
/* ================================
   Handle complete transaction
   ================================ */
if (isset($_POST['complete_transaction'])) {
    $paymentMode = $conn->real_escape_string($_POST['payment_mode'] ?? 'cash');
    $cashReceived = floatval($_POST['cash_received'] ?? 0);

    // Update quantities from cashier input
    if (isset($_POST['quantities'])) {
        foreach ($_POST['quantities'] as $productId => $qty) {
            foreach ($_SESSION['cart'] as &$item) {
                if ($item['id'] == $productId) {
                    $item['qty'] = max(1, intval($qty));
                    break;
                }
            }
        }
    }

    if (!empty($_SESSION['cart'])) {
        $transactionId = $_SESSION['txn_id'];
        $totalAmount = 0;

        // Calculate total amount first
        foreach ($_SESSION['cart'] as $item) {
            $totalAmount += $item['price'] * $item['qty'];
        }

        // Calculate balance
        $balance = $cashReceived - $totalAmount;

        // Save sales and update stock
        foreach ($_SESSION['cart'] as $item) {
            $productId = $item['id'];
            $qty = $item['qty'];
            $price = $item['price'];
            $total = $price * $qty;

            // Fixed INSERT statement - using correct variables
            $conn->query("INSERT INTO sales 
                (transaction_id, product_id, qty, price, total, payment_mode, cash_received, balance) 
                VALUES 
                ('$transactionId', '$productId', '$qty', '$price', '$total', '$paymentMode', '$cashReceived', '$balance')");

            $conn->query("UPDATE products SET quantity = quantity - $qty WHERE id = $productId");
        }

        // Clear cart
        $_SESSION['cart'] = [];
        unset($_SESSION['txn_id']);

        // Rest of your success popup code...
        echo "
        <script>
          document.addEventListener('DOMContentLoaded', function() {
              const popup = document.createElement('div');
              popup.innerHTML = `
                <div id='popupBox' style='
                  position: fixed;
                  top: 50%;
                  left: 50%;
                  transform: translate(-50%, -50%);
                  background: #f9f9f9;
                  padding: 25px;
                  border-radius: 12px;
                  border: 1px solid #ddd;
                  box-shadow: 0 4px 15px rgba(0,0,0,0.3);
                  z-index: 1000;
                  text-align: center;
                  font-family: Arial, sans-serif;
                  min-width: 300px;
                '>
                  <h3 style='margin-bottom: 15px; color: #333;'>Transaction Completed</h3>
                  <p style='margin: 5px 0;'>Total: <strong>$totalAmount</strong></p>
                  <p style='margin: 5px 0;'>Cash Received: <strong>$cashReceived</strong></p>
                  <p style='margin: 5px 0;'>Balance: <strong>$balance</strong></p>
                  <button id='closePopup' style='
                    margin-top: 15px;
                    padding: 8px 18px;
                    border: none;
                    border-radius: 8px;
                    background: #007bff;
                    color: #fff;
                    font-size: 14px;
                    cursor: pointer;
                  '>OK (Enter)</button>
                </div>
              `;
              document.body.appendChild(popup);

              const closeBtn = document.getElementById('closePopup');
              closeBtn.focus();

              closeBtn.addEventListener('click', function() {
                  window.location.href = 'Cashier.php';
              });

              document.addEventListener('keydown', function(e) {
                  if (e.key === 'Enter') {
                      window.location.href = 'Cashier.php';
                  }
              });
          });
        </script>";
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Point of Sale System</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="style.css">
<style>
    header {
    background: #755d70ff;       /* light gray background */
    padding: 12px 20px;
    border-radius: 8px;
    margin-bottom: 15px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
}
.barcode-section {
    background: #f9f9f9;       /* slightly lighter background */
    border: 1px solid #ddd;
    border-radius: 8px;
    padding: 15px;
    margin-bottom: 15px;
    box-shadow: 0 1px 5px rgba(0,0,0,0.08);
}
/* Calculator link section inside transaction */
.section-header {
    background: #f4f4f4;
    padding: 10px 15px;
    border-radius: 8px;
    margin-bottom: 10px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}
  #recent-scan-box {
    display: grid;
    grid-template-columns: 2fr 1fr 1fr 1fr 0.5fr;
    gap: 10px;
    padding: 10px;
    font-size: 18px;
    font-weight: bold;
    text-align: left;
    margin-bottom: 10px;
    border-radius: 6px;
    
    color: inherit; /* normal text */
}
.barcode-left {
    background: transparent !important;
    border: none !important;
    box-shadow: none !important;
    padding: 0 !important;
}

.transaction-section {
    overflow-y: auto;   /* vertical scroll if content too long */
    overflow-x: hidden; /* disable horizontal scroll */
}

#recent-scan-box.active {
    background: #7e6dbb17; /* black background when active */
    color: #0f0;      /* green text */
}

#recent-scan-box span.placeholder {
    color: #666; /* gray when empty */
}
#recent-scan-box.active span.placeholder {
    color: #064; /* darker green when active */
}



    /* Adjust barcode section layout */
.barcode-section {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 20px;
    margin-bottom: 15px;
}

/* Left side: recently scanned */
.barcode-left {
    flex: 1;
    padding: 10px;
    background: #f8f8f8;
    border: 1px solid #ddd;
    border-radius: 6px;
}

/* Right side: barcode input */
.barcode-right {
    width: 320px;  /* same as transaction details width */
    padding: 10px;
    background: #f8f8f8;
    border: 1px solid #ddd;
    border-radius: 6px;
}

/* Match transaction details box */
.transaction-section {
    width: 300px;
    border-left: 1px solid #ccc;
    padding-left: 10px;
}


    /* Keep products + transaction details side by side */
.products-section, .transaction-details {
    flex: 1;
}

/* Limit product table height so it scrolls instead of expanding */
.product-table-container {
    max-height: 400px;      /* adjust based on your screen */
    overflow-y: auto;       /* scroll inside */
    display: block;         /* make sure table stays inside */
}

/* Sticky header */
.product-table thead th {
    position: sticky;
    top: 0;
    background: #f8f8f8;       /* same dark style */
    color: #000;
    z-index: 2;
}

   #live-time {
    background: #000;
    color: #00ff00;
    font-weight: bold;
    padding: 4px 10px;
    border-radius: 6px;
    margin-left: 8px;
    font-size: 15px;
    display: inline-block;
}

    /* Separator line */
.txn-separator {
    border: none;
    border-top: 2px solid #ccc;
    margin: 10px 0;
}

/* Payment box styling */
.payment-box {
    background: #222222ff;          /* dark background */
    color: #0f0;              /* green text */
    padding: 15px;
    border-radius: 8px;
    margin-bottom: 15px;
}

.payment-box .detail-row,
.payment-box .cash-input-row {
    margin-bottom: 10px;
    font-size: 18px;
    font-weight: bold;
}

.payment-box .detail-label {
    display: inline-block;
    width: 140px;
}

.payment-box .detail-value {
    font-size: 22px;
}



    .home-link {
    color: white !important;     /* make icon white */
    font-size: 20px;             /* adjust icon size */
    text-decoration: none;       /* remove underline */
}

.home-link:hover {
    color: #ccc;                 /* lighter on hover */
}


    
    .total-display, .balance-display {
    background: #000;          /* black background */
    font-size: 32px;           /* large font */
    font-weight: bold;         /* bold text */
    text-align: right;         /* align numbers */
    padding: 15px 20px;
    border-radius: 8px;
    margin-top: 15px;
    box-shadow: 0 0 10px rgba(0,255,0,0.3); /* glowing effect */
}

.total-display {
    color: #00ff00; /* always green */
}

.balance-display {
    color: #00ff00; /* default green */
}

.balance-negative {
    color: red !important;
    animation: blink 1s infinite;
}

@keyframes blink {
    0%, 50%, 100% { opacity: 1; }
    25%, 75% { opacity: 0; }
}


    .low-stock { color: red; font-weight: bold; margin-left: 5px; }
    .main-content { display: flex; gap: 10px; }
    .products-section { flex: 3; }
    .transaction-section { flex: 1; border-left: 1px solid #ccc; padding-left: 10px; }
    .product-table { width: 100%; border-collapse: collapse; }
    .product-table th, .product-table td { border: 1px solid #ddd; padding: 8px; }
    .delete-btn i { color: white; font-size: 18px; }
    .delete-btn:hover i { color: darkred; }
    .section-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px; }
    .calc-link { background: #007bff; color: white; padding: 6px 3px; border-radius: 6px; text-decoration: none; font-size: 11px; }
    .calc-link:hover { background: #0056b3; }
    /* Calculator Modal */
    #calculator-modal {
        display:none; position:fixed; top:50%; left:50%;
        transform:translate(-50%, -50%);
        background:#fff; border-radius:8px; padding:20px;
        z-index:1000; box-shadow:0 4px 20px rgba(0,0,0,0.3);
        width:280px;
    }
    #calc-header { background:#007bff; color:#fff; padding:8px; margin:-20px -20px 10px -20px; border-radius:8px 8px 0 0; }
    #calc-display { width:100%; height:40px; text-align:right; margin-bottom:10px; padding:5px; font-size:16px; }
    .calc-grid { display:grid; grid-template-columns:repeat(4,1fr); gap:8px; }
    .calc-btn, #calc-equals, #calc-clear {
        padding:15px; font-size:16px; border:none; border-radius:6px;
        background:#f1f1f1; cursor:pointer; transition:background 0.2s;
    }
    .calc-btn:hover, #calc-equals:hover, #calc-clear:hover { background:#ddd; }
    #calc-equals { background:#28a745; color:#fff; }
    #calc-equals:hover { background:#218838; }
    #calc-clear { background:#dc3545; color:#fff; grid-column: span 4; }
    #calc-clear:hover { background:#c82333; }
    .muwaka{
        color:red;
        
    }
    .muwak{
        display: inline;
    }
    .muwak span{
       color:red;
    }
    .page-wrapper {
    border: 3px solid #444;       /* dark gray border */
    border-radius: 12px;          /* rounded corners */
    padding: 20px;                /* space inside */
    margin: 20px auto;            /* space around page */
    max-width: 1200px;            /* keep centered & not too wide */
    background: #fff;             /* clean white background */
    box-shadow: 0 4px 20px rgba(0,0,0,0.1); /* soft shadow */
}

</style>
</head>
<body>
    <div class="page-wrapper">
<div class="container">
<header>
    <div class="cashier-name">
        CASHIER NAME 
        <span class="txn-id">
            | Transaction: <?= $transactionId ?> 
            | <span id="live-time"><?= date("l, h:i:s A") ?></span>
        </span>
    </div>
    <nav>
       <h4 class="muwak">
  <a href="admin.php" style="text-decoration:none; color:inherit;">
    <span>MUWAKA</span> ENTERPRISE
  </a>
</h4>

        <a href="index.php" class="home-link"><i class="fas fa-home"></i></a>
    </nav>
</header>


<!-- Barcode Input -->
<div class="barcode-section">
    <div class="barcode-left">
    <div id="recent-scan-box"></div>
</div>
    <div class="barcode-right">
        <div class="barcode-input-container" style="position:relative;">
            <input type="text" id="barcode-input" placeholder="Scan barcode or enter product name/code" autocomplete="off" class="barcode-input">
            <button type="button" class="scan-button" id="scan-button"><i class="fas fa-barcode"></i> Scan</button>
            <div id="suggestions" style="position:absolute; top:40px; left:0; width:100%; background:white; border:1px solid #ccc; z-index:999; display:none;"></div>
        </div>
    </div>
</div>


<div class="main-content" style="display:flex; gap:20px;">
    <div class="products-section">
        <div class="product-table-container">
            <table class="product-table">
                <thead>
                    <tr>
                        <th>Item Name</th>
                        <th>Price</th>
                        <th>Quantity</th>
                        <th>Total</th>
                        <th>Remove</th>
                    </tr>
                </thead>
                <tbody id="product-list">
<?php 
$grandTotal = 0;
$products = $_SESSION['cart'] ?? [];

foreach ($products as $item):
    $lineTotal = $item['price'] * $item['qty'];
    $grandTotal += $lineTotal;

    $stockResult = $conn->query("SELECT quantity FROM products WHERE id=".$item['id']." LIMIT 1");
    $currentStock = $stockResult ? $stockResult->fetch_assoc()['quantity'] : 0;
    $lowStock = ($currentStock <= 5) ? '<span class="low-stock">!</span>' : '';
?>
<tr class="product-item" data-id="<?= $item['id'] ?>" data-stock="<?= $currentStock ?>">
    <td><?= htmlspecialchars($item['name']) ?> <?= $lowStock ?></td>
    <td class="product-price" data-price="<?= $item['price'] ?>">KSH.<?= number_format($item['price'], 2) ?></td>
    <td><input type="number" name="quantities[<?= $item['id'] ?>]" class="product-quantity-input" value="<?= $item['qty'] ?>" min="1" max="<?= $currentStock ?>" form="checkout-form"></td>
    <td class="product-total">KSH.<?= number_format($lineTotal, 2) ?></td>
    <td><a href="?delete=<?= $item['id'] ?>" class="delete-btn"><i class="fas fa-times"></i></a></td>
</tr>
<?php endforeach; ?>
            </tbody>
            </table>
        </div>
    </div>

    <!-- Transaction Section -->
   <div class="transaction-section">
   <div class="section-header">
        <h3 class="section-title">Transaction</h3>
        <a href="#" id="open-calculator" class="calc-link"><i class="fas fa-calculator"></i> Calculator</a>
   </div>

   <hr class="txn-separator">

   <div class="payment-box">
       
<?php 
$vatRate = 0.16; // 16% VAT
$vatAmount = $grandTotal * $vatRate;
$netTotal = $grandTotal + $vatAmount;

?>

<div class="detail-row">
    <span class="detail-label">VAT (16%):</span> 
    <span class="detail-value" id="vat-amount">KSH.<?= number_format($vatAmount, 2) ?></span>
</div>
<div class="detail-row total-row">
    <span class="detail-label">Net Total:</span> 
    <span class="detail-value" id="net-total">KSH.<?= number_format($netTotal, 2) ?></span>
</div>

<div class="detail-row">
    <span class="detail-label">Total Amount (Subtotal):</span> 
    <span class="detail-value" id="total-amount">KSH.<?= number_format($grandTotal, 2) ?></span>
</div>

       <div class="cash-input-row">
           <span class="detail-label">Customer Cash:</span>
           <div class="cash-input-container">
               <span></span>
              <input 
    type="number" 
    name="cash_received"   
    class="cash-input" 
    id="cash-input" 
    value="0.00" 
    min="0" 
    step="0.01"
    form="checkout-form">   <!-- link to your form -->

           </div>
       </div>
       <div class="detail-row"><span class="detail-label">Balance:</span> <span class="detail-value" id="balance-amount">0.00</span></div>
   </div>
<form id="checkout-form" action="Cashier.php" method="post">
    <div class="detail-row">
        <label for="payment_mode" class="detail-label">Payment Mode:</label>
        <select name="payment_mode" id="payment_mode">
            <option value="cash" selected>Cash</option>
            <option value="mpesa">M-Pesa</option>
        </select>
    </div>
    
    <button type="submit" id="complete-transaction" name="complete_transaction" class="complete-transaction">
        COMPLETE TRANSACTION
    </button>
</form>


</div>


<!-- Calculator Modal -->
<div id="calculator-modal">
    <div id="calc-header">
        <strong>Calculator</strong>
        <button id="close-calculator" style="float:right; background:none; border:none; font-size:16px; cursor:pointer; color:#fff;">✖</button>
    </div>
    <input type="text" id="calc-display" disabled>
    <div class="calc-grid">
        <button class="calc-btn">7</button>
        <button class="calc-btn">8</button>
        <button class="calc-btn">9</button>
        <button class="calc-btn">/</button>
        <button class="calc-btn">4</button>
        <button class="calc-btn">5</button>
        <button class="calc-btn">6</button>
        <button class="calc-btn">*</button>
        <button class="calc-btn">1</button>
        <button class="calc-btn">2</button>
        <button class="calc-btn">3</button>
        <button class="calc-btn">-</button>
        <button class="calc-btn">0</button>
        <button class="calc-btn">.</button>
        <button id="calc-equals">=</button>
        <button class="calc-btn">+</button>
    </div>
    <button id="calc-clear">Clear</button>
</div>
<!-- Net Total & Balance Popup -->
<div id="net-balance-popup" style="
    display:none;
    position:fixed;
    top:50%;
    left:50%;
    transform:translate(-50%, -50%);
    background:#000;
    color:#0f0;
    font-size:28px;
    font-weight:bold;
    padding:20px 40px;
    border-radius:12px;
    text-align:center;
    box-shadow:0 0 25px rgba(0,255,0,0.7);
    z-index:3000;
">
    <div>  <span id="popup-net"></span></div>
   
</div>
</div> 
<script>
   function updateRecentScan(product) {
    const recentBox = document.getElementById("recent-scan-box");
    recentBox.innerHTML = `
        <span>${product.name}</span>
        <span>$${parseFloat(product.sale_price).toFixed(2)}</span>
        <span class="placeholder">*</span>
        <span class="placeholder">*</span>
        <span class="placeholder">*</span>
    `;

    recentBox.classList.add("active"); // make black + green
    recentBox.classList.add("blink");
    setTimeout(() => recentBox.classList.remove("blink"), 800);
}




    // Toggle popup with ↑ key
document.addEventListener("keydown", function(e) {
    if (e.key === "ArrowUp") {
        const popup = document.getElementById("net-balance-popup");

        if (popup.style.display === "block") {
            popup.style.display = "none"; // hide if already visible
        } else {
            const net = document.getElementById("net-total").textContent;
          
            document.getElementById("popup-net").textContent = net;
          
            popup.style.display = "block"; // show at center
        }
    }
});

// ================= BARCODE & CART =================
document.addEventListener("DOMContentLoaded", function () {
    const barcodeInput = document.getElementById("barcode-input"); 
    const productList = document.getElementById("product-list");   
    const suggestionBox = document.getElementById("suggestions");
    barcodeInput.focus();
    let typingTimer;

    barcodeInput.addEventListener("input", function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(() => {
            let code = barcodeInput.value.trim();
            if (code.length > 0) {
                if (/^\d+$/.test(code)) {
                    fetch("Cashier.php", {
                        method: "POST",
                        headers: {"Content-Type": "application/x-www-form-urlencoded"},
                        body: "barcode=" + encodeURIComponent(code) + "&ajax=1"
                    })
                    .then(res => res.json())
                    .then(product => {
                        if (product.success) {
                            addToCart(product);
                            barcodeInput.value = "";
                            updateTotals();
                        }
                    });
                } else {
                    fetch("Cashier.php", {
                        method: "POST",
                        headers: {"Content-Type": "application/x-www-form-urlencoded"},
                        body: "search_name=" + encodeURIComponent(code) + "&ajax=1"
                    })
                    .then(res => res.json())
                    .then(products => {
                        suggestionBox.innerHTML = "";
                        if (products.length > 0) {
                            products.forEach(p => {
                                let div = document.createElement("div");
                                div.textContent = p.name + " ($" + parseFloat(p.sale_price).toFixed(2) + ")";
                                div.addEventListener("click", function () {
                                    addToCart(p);
                                    suggestionBox.style.display = "none";
                                    barcodeInput.value = "";
                                    updateTotals();
                                });
                                suggestionBox.appendChild(div);
                            });
                            suggestionBox.style.display = "block";
                        } else suggestionBox.style.display = "none";
                    });
                }
            } else suggestionBox.style.display = "none";
        }, 300);
    });

    function addToCart(product) {
    let existingRow = document.querySelector(`#product-list tr[data-id="${product.id}"]`);
    if (existingRow) {
        let qtyInput = existingRow.querySelector(".product-quantity-input");
        qtyInput.value = parseInt(qtyInput.value) + 1;
    } else {
        let newRow = `
            <tr data-id="${product.id}">
                <td>${product.name}</td>
                <td class="product-price" data-price="${product.sale_price}">$${parseFloat(product.sale_price).toFixed(2)}</td>
                <td><input type="number" name="quantities[${product.id}]" class="product-quantity-input" value="1" min="1" form="checkout-form"></td>
                <td class="product-total">${parseFloat(product.sale_price).toFixed(2)}</td>
                <td><a href="?delete=${product.id}" class="delete-btn"><i class="fas fa-times"></i></a></td>
            </tr>`;
        productList.insertAdjacentHTML("beforeend", newRow);
    }

    // Save to session cart
    fetch("Cashier.php", {
        method: "POST",
        headers: {"Content-Type": "application/x-www-form-urlencoded"},
        body: "update_cart=1&product_id=" + product.id +
              "&product_name=" + encodeURIComponent(product.name) +
              "&product_price=" + product.sale_price
    });

    // ✅ Update recent scanned product (this was misplaced before)
    updateRecentScan(product);
}


    function updateTotals() {
    let rows = document.querySelectorAll("#product-list tr");
    let grandTotal = 0;

    // calculate subtotal
    rows.forEach(row => {
        let price = parseFloat(row.querySelector(".product-price").dataset.price);
        let qty = parseInt(row.querySelector(".product-quantity-input").value) || 0;
        let total = price * qty;
        row.querySelector(".product-total").textContent = "$" + total.toFixed(2);
        grandTotal += total;
    });

    // update subtotal
    document.getElementById("total-amount").textContent = "$" + grandTotal.toFixed(2);

    // recalc VAT and net total
    let vatRate = 0.16;
    let vatAmount = grandTotal * vatRate;
    let netTotal = grandTotal + vatAmount;

    document.getElementById("vat-amount").textContent = "$" + vatAmount.toFixed(2);
    document.getElementById("net-total").textContent = "$" + netTotal.toFixed(2);

    // balance from net total
    let cash = parseFloat(document.getElementById("cash-input").value) || 0;
    document.getElementById("balance-amount").textContent = "$" + (cash - netTotal).toFixed(2);
}

// run totals when qty or cash changes
document.addEventListener("input", function (e) {
    if (e.target.classList.contains("product-quantity-input") || e.target.id === "cash-input") {
        updateTotals();
    }
});

// initial call
updateTotals();

});

// ================= CALCULATOR =================
document.getElementById("open-calculator").addEventListener("click", function(e){
    e.preventDefault();
    document.getElementById("calculator-modal").style.display = "block";
});
document.getElementById("close-calculator").addEventListener("click", function(){
    document.getElementById("calculator-modal").style.display = "none";
});

let calcDisplay = document.getElementById("calc-display");
let currentInput = "";

document.querySelectorAll(".calc-btn").forEach(btn => {
    btn.addEventListener("click", () => {
        currentInput += btn.textContent;
        calcDisplay.value = currentInput;
    });
});

document.getElementById("calc-equals").addEventListener("click", () => {
    try {
        currentInput = eval(currentInput).toString();
        calcDisplay.value = currentInput;
    } catch {
        calcDisplay.value = "Error";
        currentInput = "";
    }
});

document.getElementById("calc-clear").addEventListener("click", () => {
    currentInput = "";
    calcDisplay.value = "";
});

// Check if quantity exceeds stock
document.querySelectorAll(".product-quantity-input").forEach(input => {
    input.addEventListener("input", function () {
        let maxStock = parseInt(this.getAttribute("max"));
        let enteredQty = parseInt(this.value);

        if (enteredQty > maxStock) {
            alert("⚠️ Quantity cannot exceed available stock (" + maxStock + ").");
            this.value = maxStock; // reset back to max
        }
    });
});



const cashInput = document.getElementById("cash-input");

// Clear 0.00 when cashier starts typing
cashInput.addEventListener("focus", function () {
    if (this.value === "0.00" || this.value === "0") {
        this.value = "";
    }
});

// If cashier leaves it empty, reset to 0.00
cashInput.addEventListener("blur", function () {
    if (this.value.trim() === "") {
        this.value = "0.00";
    }
});

function updateTime() {
    const now = new Date();
    const options = { weekday: 'long', hour: '2-digit', minute: '2-digit', second: '2-digit' };
    const formatted = now.toLocaleString('en-US', options);
    document.getElementById("live-time").textContent = formatted;
}

// Update immediately and then every second
updateTime();
setInterval(updateTime, 1000);



document.addEventListener("keydown", function (e) {
    // If Enter is pressed and focus is NOT on textarea
    if (e.key === "Enter" && e.target.tagName !== "TEXTAREA") {
        e.preventDefault(); // stop default behavior (like focusing buttons)

        const form = document.getElementById("checkout-form");
        if (form) {
            document.getElementById("complete-transaction").click();
        }
    }
});

</script>

</body>
</html>
